/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns.executables.kit;

import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.clickablesigns.AbstractSignClickAction;
import me.testaccount666.serversystem.commands.executables.kit.manager.Kit;
import me.testaccount666.serversystem.commands.executables.kit.manager.KitManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ChatColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.FileConfiguration;

public class ActionKitSign
extends AbstractSignClickAction {
    @Override
    public String getBasePermissionNode() {
        return "ClickableSigns.Kit";
    }

    @Override
    protected boolean executeAction(User user, Sign sign, FileConfiguration config) {
        KitManager kitManager = ServerSystem.Instance.getRegistry().getService(KitManager.class);
        if (kitManager == null) {
            MessageBuilder.sign("Kit.NoKitManager", user).build();
            return false;
        }
        String kitName = config.getString("KitName", sign.getLine(1));
        if ((kitName = ChatColor.stripColor(kitName)).isEmpty()) {
            MessageBuilder.sign("Kit.NoKitSpecified", user).build();
            return false;
        }
        Optional<Kit> kitOptional = kitManager.getKit(kitName.toLowerCase());
        if (kitOptional.isEmpty()) {
            String finalKitName = kitName;
            MessageBuilder.sign("Kit.KitNotFound", user).postModifier(message -> message.replace("<KIT>", finalKitName)).build();
            return false;
        }
        Kit kit = kitOptional.get();
        kit.giveKit(user.getPlayer());
        MessageBuilder.sign("Kit.KitGiven", user).postModifier(message -> message.replace("<KIT>", kit.getDisplayName())).build();
        return true;
    }
}

