/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.clickablesigns.executables.time;

import me.testaccount666.serversystem.clickablesigns.AbstractSignClickAction;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.ChatColor;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.FileConfiguration;

public class ActionTimeSign
extends AbstractSignClickAction {
    @Override
    public String getBasePermissionNode() {
        return "ClickableSigns.Time";
    }

    @Override
    protected boolean executeAction(User user, Sign sign, FileConfiguration config) {
        long time;
        String timeType = config.getString("TimeType", sign.getLine(1)).toLowerCase();
        if ((timeType = ChatColor.stripColor(timeType)).isEmpty()) {
            MessageBuilder.sign("Time.NoTimeSpecified", user).build();
            return false;
        }
        World world = user.getPlayer().getWorld();
        String finalTimeType = timeType;
        switch (timeType) {
            case "day": {
                time = 1000L;
                break;
            }
            case "noon": {
                time = 6000L;
                break;
            }
            case "night": {
                time = 13000L;
                break;
            }
            case "midnight": {
                time = 18000L;
                break;
            }
            default: {
                try {
                    time = Long.parseLong(timeType);
                    break;
                }
                catch (NumberFormatException ignored) {
                    MessageBuilder.sign("Time.InvalidTime", user).postModifier(message -> message.replace("<TIME>", finalTimeType)).build();
                    return false;
                }
            }
        }
        world.setTime(time);
        MessageBuilder.sign("Time.TimeSet", user).postModifier(message -> message.replace("<TIME>", finalTimeType)).build();
        return true;
    }
}

