/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.ignore;

import java.util.Optional;
import java.util.UUID;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="ignore", variants={"unignore"})
public class CommandIgnore
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (command.getName().equalsIgnoreCase("ignore")) {
            this.executeIgnore(commandSender, label, arguments);
            return;
        }
        this.executeUnignore(commandSender, label, arguments);
    }

    private void executeUnignore(User commandSender, String label, String ... arguments) {
        Optional<User> targetUserOptional = this.validateAndGetUser(commandSender, label, "Unignore", arguments);
        if (targetUserOptional.isEmpty()) {
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        UUID targetUuid = targetPlayer.getUniqueId();
        if (!commandSender.isIgnoredPlayer(targetUuid)) {
            MessageBuilder.command("Unignore.NotIgnored", commandSender).target(targetPlayer.getName()).build();
            return;
        }
        commandSender.removeIgnoredPlayer(targetUuid);
        commandSender.save();
        MessageBuilder.command("Unignore.Success", commandSender).target(targetPlayer.getName()).build();
    }

    private void executeIgnore(User commandSender, String label, String ... arguments) {
        Optional<User> targetUserOptional = this.validateAndGetUser(commandSender, label, "Ignore", arguments);
        if (targetUserOptional.isEmpty()) {
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        UUID targetUuid = targetPlayer.getUniqueId();
        if (commandSender.isIgnoredPlayer(targetUuid)) {
            MessageBuilder.command("Ignore.AlreadyIgnored", commandSender).target(targetPlayer.getName()).build();
            return;
        }
        commandSender.addIgnoredPlayer(targetUuid);
        commandSender.save();
        MessageBuilder.command("Ignore.Success", commandSender).target(targetPlayer.getName()).build();
    }

    private Optional<User> validateAndGetUser(User commandSender, String label, String command, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, command + ".Use")) {
            return Optional.empty();
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return Optional.empty();
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(null)).label(label).build();
            return Optional.empty();
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, false, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return Optional.empty();
        }
        User targetUser = targetUserOptional.get();
        boolean bl = isSelf = targetUser == commandSender;
        if (isSelf) {
            MessageBuilder.command(command + ".Self", commandSender).build();
            return Optional.empty();
        }
        return Optional.of(targetUser);
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Ignore";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        String permissionPath = command.getName().equalsIgnoreCase("ignore") ? "Ignore.Use" : "Unignore.Use";
        return PermissionManager.hasCommandPermission((CommandSender)player, permissionPath, false);
    }
}

