/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.inventorysee.utils;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.ServiceRegistry;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class InventorySeeUtils {
    public static void placeFilledMarkers(Inventory inventory, Material material, String displayName, int startSlot, int endSlot) {
        ItemStack markerItem = new ItemStack(material);
        ItemMeta itemMeta = markerItem.getItemMeta();
        itemMeta.displayName(((TextComponent)((TextComponent)Component.text((String)displayName).decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE)).color(TextColor.color((int)255, (int)0, (int)0))).asComponent());
        markerItem.setItemMeta(itemMeta);
        for (int slot = startSlot; slot < endSlot; ++slot) {
            inventory.setItem(slot, markerItem);
        }
    }

    public static void addSectionDecorators(Inventory displayInventory, boolean isOffline) {
        InventorySeeUtils.placeFilledMarkers(displayInventory, Material.ARMOR_STAND, "Armor", 45, 49);
        InventorySeeUtils.placeFilledMarkers(displayInventory, Material.APPLE, "Off-Hand", 49, 50);
        if (isOffline) {
            InventorySeeUtils.placeFilledMarkers(displayInventory, Material.BARRIER, "Unused", 50, 54);
            InventorySeeUtils.placeFilledMarkers(displayInventory, Material.BARRIER, "Unused", 41, 45);
        } else {
            InventorySeeUtils.placeFilledMarkers(displayInventory, Material.WHITE_WOOL, "Cursor", 50, 51);
            InventorySeeUtils.placeFilledMarkers(displayInventory, Material.DROPPER, "Drop item", 51, 54);
        }
    }

    public static void handleInventoryViewers(Inventory inventory, Player player, long delayTicks, BiConsumer<User, String> inventoryAction) {
        ArrayList viewers = new ArrayList(inventory.getViewers());
        inventory.close();
        Bukkit.getScheduler().runTaskLater((Plugin)ServerSystem.Instance, () -> viewers.forEach(viewer -> {
            if (!(viewer instanceof Player)) {
                return;
            }
            Player commandSenderPlayer = (Player)viewer;
            ServiceRegistry registry = ServerSystem.Instance.getRegistry();
            UserManager userManager = registry.getService(UserManager.class);
            Optional<CachedUser> cachedUserOptional = userManager.getUser(commandSenderPlayer);
            if (cachedUserOptional.isEmpty()) {
                return;
            }
            CachedUser cachedUser = cachedUserOptional.get();
            if (cachedUser.isOfflineUser()) {
                return;
            }
            User user = (User)cachedUser.getOfflineUser();
            inventoryAction.accept(user, player.getName());
        }), delayTicks);
    }
}

