/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.moderation;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.moderation.AbstractModeration;
import me.testaccount666.serversystem.moderation.AbstractModerationManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.utils.DurationParser;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;

public abstract class AbstractModerationCommand
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, command)) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        if (!this.isRemoveModeration(command) && arguments.length < 2) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<CachedUser> targetOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(arguments[0]);
        if (targetOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        CachedUser cachedUser = targetOptional.get();
        OfflineUser targetUser = cachedUser.getOfflineUser();
        if (targetUser.getName().isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        if (this.isRemoveModeration(command)) {
            this.handleRemoveModeration(command, commandSender, targetUser);
            return;
        }
        long duration = DurationParser.parseDuration(arguments[1]);
        if (duration == -2L) {
            MessageBuilder.command("Moderation.InvalidDuration", commandSender).target(targetUser.getName().get()).build();
            return;
        }
        if (duration == 0L) {
            MessageBuilder.command("Moderation.NotZero", commandSender).target(targetUser.getName().get()).build();
            return;
        }
        long currentTime = System.currentTimeMillis();
        long expireTime = duration == -1L ? -1L : currentTime + duration;
        Optional<String> defaultReason = MessageBuilder.command("Moderation.DefaultReason", commandSender).target(targetUser.getName().get()).prefix(false).send(false).build();
        if (defaultReason.isEmpty()) {
            ServerSystem.getLog().severe("(Command: " + command.getName() + ") Default reason is empty! This should not happen!");
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).build();
            return;
        }
        String reason = defaultReason.get();
        if (arguments.length > 2) {
            reason = IntStream.range(2, arguments.length).mapToObj(index -> arguments[index] + " ").collect(Collectors.joining());
        }
        this.handleCreateModeration(command, commandSender, targetUser, expireTime, reason);
    }

    private void handleRemoveModeration(Command command, User commandSender, OfflineUser targetUser) {
        AbstractModerationManager moderationManager = this.getModerationManager(targetUser);
        Optional<AbstractModeration> activeModeration = moderationManager.getActiveModeration();
        if (activeModeration.isEmpty()) {
            MessageBuilder.general("Moderation." + this.type(command) + ".Remove.NoActiveModeration", commandSender).target(targetUser.getName().get()).build();
            return;
        }
        moderationManager.removeModeration(activeModeration.get());
        MessageBuilder.command("Moderation." + this.type(command) + ".Remove.Success", commandSender).target(targetUser.getName().get()).build();
    }

    private void handleCreateModeration(Command command, User commandSender, OfflineUser targetUser, long expireTime, String reason) {
        AbstractModerationManager moderationManager = this.getModerationManager(targetUser);
        if (moderationManager.hasActiveModeration()) {
            MessageBuilder.general("Moderation." + this.type(command) + ".Add.AlreadyActiveModeration", commandSender).target(targetUser.getName().get()).build();
            return;
        }
        AbstractModeration moderation = this.createModeration(command, commandSender, targetUser, expireTime, reason);
        moderationManager.addModeration(moderation);
        MessageBuilder.command("Moderation." + this.type(command) + ".Add.Success", commandSender).target(targetUser.getName().get()).build();
        this.handlePostModeration(command, commandSender, targetUser, moderation);
    }

    protected abstract void handlePostModeration(Command var1, User var2, OfflineUser var3, AbstractModeration var4);

    protected abstract AbstractModeration createModeration(Command var1, User var2, OfflineUser var3, long var4, String var6);

    protected abstract boolean checkBasePermission(User var1, Command var2);

    protected boolean isRemoveModeration(Command command) {
        return command.getName().startsWith("un");
    }

    protected abstract AbstractModerationManager getModerationManager(OfflineUser var1);

    protected abstract String type(Command var1);
}

