/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.offlineteleport;

import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.offlineteleport.TabCompleterOfflineTeleport;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="offlineteleport", variants={"offlineteleporthere"}, tabCompleter=TabCompleterOfflineTeleport.class)
public class CommandOfflineTeleport
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (command.getName().equalsIgnoreCase("offlineteleport")) {
            this.handleOfflineTeleport(commandSender, command, label, arguments);
            return;
        }
        if (command.getName().equalsIgnoreCase("offlineteleporthere")) {
            this.handleOfflineTeleportHere(commandSender, command, label, arguments);
        }
    }

    private void handleOfflineTeleport(User commandSender, Command command, String label, String ... arguments) {
        Optional<CachedUser> cachedUserOptional = this.getTargetUser(commandSender, label, arguments[0]);
        if (cachedUserOptional.isEmpty()) {
            return;
        }
        CachedUser cachedUser = cachedUserOptional.get();
        String targetName = cachedUser.getOfflineUser().getName().orElse(arguments[0]);
        commandSender.getPlayer().teleport(cachedUser.getOfflineUser().getLogoutPosition());
        MessageBuilder.command("OfflineTeleport.Success", commandSender).target(targetName).build();
    }

    private void handleOfflineTeleportHere(User commandSender, Command command, String label, String ... arguments) {
        Optional<CachedUser> cachedUserOptional = this.getTargetUser(commandSender, label, arguments[0]);
        if (cachedUserOptional.isEmpty()) {
            return;
        }
        CachedUser cachedUser = cachedUserOptional.get();
        String targetName = cachedUser.getOfflineUser().getName().orElse(arguments[0]);
        cachedUser.getOfflineUser().setLogoutPosition(commandSender.getPlayer().getLocation());
        cachedUser.getOfflineUser().save();
        MessageBuilder.command("OfflineTeleportHere.Success", commandSender).target(targetName).build();
    }

    private Optional<CachedUser> getTargetUser(User commandSender, String label, String name) {
        Optional<CachedUser> cachedUserOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(name);
        if (cachedUserOptional.isEmpty()) {
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).target(name).build();
            return Optional.empty();
        }
        CachedUser cachedUser = cachedUserOptional.get();
        String targetName = cachedUser.getOfflineUser().getName().orElse(name);
        if (cachedUser.isOnlineUser()) {
            MessageBuilder.general("Offline.NotOffline", commandSender).target(targetName).build();
            return Optional.empty();
        }
        return Optional.of(cachedUser);
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "OfflineTeleport";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        if (command.getName().equalsIgnoreCase("offlineteleport")) {
            return PermissionManager.hasCommandPermission((CommandSender)player, "OfflineTeleport.Use", false);
        }
        return PermissionManager.hasCommandPermission((CommandSender)player, "OfflineTeleportHere.Use", false);
    }
}

