/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.privatemessage;

import java.util.Optional;
import java.util.Set;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.privatemessage.CommandPrivateMessage;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.events.UserPrivateMessageEvent;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

@RequiredCommands(requiredCommands={CommandPrivateMessage.class})
public class ListenerSocialSpy
implements Listener {
    public boolean canRegister(Set<ServerSystemCommandExecutor> requiredCommands) {
        return requiredCommands.stream().anyMatch(CommandPrivateMessage.class::isInstance);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPrivateMessage(UserPrivateMessageEvent event) {
        ServerSystem.Instance.getRegistry().getService(UserManager.class).getCachedUsers().forEach(cachedUser -> {
            if (!cachedUser.isOnlineUser()) {
                return;
            }
            User user = (User)cachedUser.getOfflineUser();
            if (!user.isSocialSpyEnabled()) {
                return;
            }
            Optional<User> target = event.getRecipients().stream().filter(recipient -> !recipient.equals(event.getSender())).findFirst();
            if (target.isEmpty()) {
                return;
            }
            String senderName = event.getSender().getName().get();
            String targetName = target.get().getName().get();
            MessageBuilder.command("SocialSpy.Format", user).sender(senderName).target(targetName).prefix(false).postModifier(message -> message.replace("<MESSAGE>", event.getMessage())).build();
        });
    }
}

