/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.skull;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class SkullCreator {
    private static final Path _DATA_DIRECTORY = Path.of("plugins", "ServerSystem", "data");
    private static final Path _CACHE_FILE = _DATA_DIRECTORY.resolve("MineSkinCache.zip");

    private static HttpURLConnection createConnection() throws URISyntaxException, IOException {
        URL apiURL = new URI("https://api.mineskin.org/v2/generate").toURL();
        HttpURLConnection connection = (HttpURLConnection)apiURL.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        int timeOut = (int)TimeUnit.SECONDS.toMillis(30L);
        connection.setConnectTimeout(timeOut);
        connection.setReadTimeout(timeOut);
        return connection;
    }

    public ItemStack getSkull(UUID uuid) {
        PlayerProfile playerProfile = Bukkit.createProfile((UUID)uuid);
        return this.getSkullByPlayerProfile(playerProfile);
    }

    public ItemStack getSkull(String name) {
        PlayerProfile playerProfile = Bukkit.createProfile((String)name);
        return this.getSkullByPlayerProfile(playerProfile);
    }

    public ItemStack getSkull(OfflinePlayer offlinePlayer) {
        PlayerProfile playerProfile = offlinePlayer.getPlayerProfile();
        return this.getSkullByPlayerProfile(playerProfile);
    }

    public ItemStack getSkullByTexture(String base64) {
        try {
            return this.getSkullByTexture(URI.create(new String(Base64.getDecoder().decode(base64))).toURL());
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException(exception);
        }
    }

    public ItemStack getSkullByTexture(URL textureURL) {
        try {
            String response = this.getResponse(textureURL);
            JsonObject root = JsonParser.parseString((String)response).getAsJsonObject();
            JsonObject texture = root.getAsJsonObject("skin").getAsJsonObject("texture").getAsJsonObject("data");
            String value = texture.get("value").getAsString();
            String signature = texture.get("signature").getAsString();
            PlayerProfile playerProfile = Bukkit.getServer().createProfile(UUID.randomUUID());
            playerProfile.setProperty(new ProfileProperty("textures", value, signature));
            return this.getSkullByPlayerProfile(playerProfile);
        }
        catch (Exception exception) {
            ServerSystem.getLog().log(Level.WARNING, "An error occurred trying to fetch skin from Mineskin for URL '" + String.valueOf(textureURL) + "'", exception);
            return null;
        }
    }

    private synchronized Optional<String> getCachedResponse(URL textureURL) throws IOException {
        if (!Files.exists(_DATA_DIRECTORY, new LinkOption[0])) {
            Files.createDirectories(_DATA_DIRECTORY, new FileAttribute[0]);
        }
        String base64 = Base64.getUrlEncoder().withoutPadding().encodeToString(textureURL.toString().getBytes(StandardCharsets.UTF_8));
        String entryName = base64 + ".json";
        if (!Files.exists(_CACHE_FILE, new LinkOption[0])) {
            return Optional.empty();
        }
        URI zipUri = URI.create("jar:" + String.valueOf(_CACHE_FILE.toUri()));
        try (FileSystem zipFileSystem = this.getFileSystem(zipUri, Map.of());){
            Path entry = zipFileSystem.getPath("/" + entryName, new String[0]);
            if (!Files.exists(entry, new LinkOption[0])) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            Optional<String> optional = Optional.of(Files.readString(entry, StandardCharsets.UTF_8));
            return optional;
        }
    }

    private FileSystem getFileSystem(URI zipUri, Map<String, Object> environment) throws IOException {
        try {
            return FileSystems.newFileSystem(zipUri, environment);
        }
        catch (FileSystemAlreadyExistsException exception) {
            return FileSystems.getFileSystem(zipUri);
        }
    }

    private String getResponse(URL textureURL) throws IOException, URISyntaxException {
        String response;
        Optional<String> cachedResponse = this.getCachedResponse(textureURL);
        if (cachedResponse.isPresent()) {
            return cachedResponse.get();
        }
        String jsonPayload = "{\n  \"variant\":\"classic\",\n  \"visibility\":\"public\",\n  \"url\":\"" + String.valueOf(textureURL) + "\"\n}\n";
        HttpURLConnection connection = SkullCreator.createConnection();
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(jsonPayload.getBytes(StandardCharsets.UTF_8));
        }
        int status = connection.getResponseCode();
        ServerSystem.getLog().fine("'" + String.valueOf(textureURL) + "' got http response: " + status);
        ServerSystem.getLog().fine("'" + String.valueOf(textureURL) + "' got txt response: " + connection.getResponseMessage());
        boolean success = status >= 200 && status < 300;
        try (Scanner scanner = new Scanner(new InputStreamReader(success ? connection.getInputStream() : connection.getErrorStream(), StandardCharsets.UTF_8));){
            response = scanner.useDelimiter("\\A").next();
        }
        if (!success) {
            if (status == 400) {
                throw new IllegalArgumentException("Got status '400', is '" + String.valueOf(textureURL) + "' directly pointing to an image? " + response);
            }
            throw new IllegalArgumentException("Got status '" + status + "' for '" + String.valueOf(textureURL) + "' with message: " + response);
        }
        this.saveResponse(textureURL, response);
        return response;
    }

    private synchronized void saveResponse(URL textureURL, String response) throws IOException {
        if (!Files.exists(_DATA_DIRECTORY, new LinkOption[0])) {
            Files.createDirectories(_DATA_DIRECTORY, new FileAttribute[0]);
        }
        String base64 = Base64.getUrlEncoder().withoutPadding().encodeToString(textureURL.toString().getBytes(StandardCharsets.UTF_8));
        String entryName = base64 + ".json";
        HashMap<String, Object> environment = new HashMap<String, Object>();
        if (!Files.exists(_CACHE_FILE, new LinkOption[0])) {
            environment.put("create", true);
        }
        environment.put("compressionLevel", 3);
        URI zipUri = URI.create("jar:" + String.valueOf(_CACHE_FILE.toUri()));
        try (FileSystem zipFileSystem = this.getFileSystem(zipUri, environment);){
            Path entry = zipFileSystem.getPath("/" + entryName, new String[0]);
            Files.writeString(entry, (CharSequence)response, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    private ItemStack getSkullByPlayerProfile(PlayerProfile playerProfile) {
        ItemStack skullItem = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)skullItem.getItemMeta();
        assert (skullMeta != null);
        skullMeta.setPlayerProfile(playerProfile);
        skullItem.setItemMeta((ItemMeta)skullMeta);
        return skullItem;
    }
}

