/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.spawn;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.config.ConfigurationManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="spawn", variants={"setspawn"})
public class CommandSpawn
extends AbstractServerSystemCommand {
    protected final FileConfiguration spawnConfiguration;
    protected final boolean teleportOnJoin;
    protected final boolean teleportOnFirstJoin;
    private final File _spawnFile = Path.of("plugins", "ServerSystem", "data", "spawn.yml").toFile();
    protected Optional<Location> spawnLocation = Optional.empty();

    public CommandSpawn() {
        Path legacySpawnFile = Path.of("plugins", "ServerSystem", "spawn.yml");
        if (legacySpawnFile.toFile().exists()) {
            legacySpawnFile.toFile().renameTo(this._spawnFile);
            ServerSystem.getLog().info("Found 'spawn.yml' in wrong directory. It was moved to '" + this._spawnFile.getAbsolutePath() + "'.");
        }
        this.spawnConfiguration = YamlConfiguration.loadConfiguration((File)this._spawnFile);
        this.saveDefaultConfig();
        ConfigurationManager configManager = ServerSystem.Instance.getRegistry().getService(ConfigurationManager.class);
        ConfigReader config = configManager.getGeneralConfig();
        this.teleportOnJoin = config.getBoolean("Join.Spawn.TeleportOnJoin");
        this.teleportOnFirstJoin = config.getBoolean("Join.Spawn.TeleportOnFirstJoin");
        if (!this.spawnConfiguration.isSet("Spawn")) {
            return;
        }
        String worldName = this.spawnConfiguration.getString("Spawn.World");
        if (worldName == null) {
            return;
        }
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return;
        }
        double x = this.spawnConfiguration.getDouble("Spawn.X");
        double y = this.spawnConfiguration.getDouble("Spawn.Y");
        double z = this.spawnConfiguration.getDouble("Spawn.Z");
        float yaw = (float)this.spawnConfiguration.getDouble("Spawn.Yaw");
        float pitch = (float)this.spawnConfiguration.getDouble("Spawn.Pitch");
        this.spawnLocation = Optional.of(new Location(world, x, y, z, yaw, pitch));
    }

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (command.getName().equalsIgnoreCase("spawn")) {
            this.handleSpawnCommand(commandSender, label, arguments);
            return;
        }
        this.handleSetSpawnCommand(commandSender, label);
    }

    protected void handleSpawnCommand(User commandSender, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "Spawn.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(null), label, arguments)) {
            return;
        }
        if (this.spawnLocation.isEmpty()) {
            MessageBuilder.command("Spawn.NoSpawnSet", commandSender).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "Spawn.Other", targetPlayer.getName())) {
            return;
        }
        targetPlayer.teleport(this.spawnLocation.get());
        String messagePath = isSelf ? "Spawn.Success" : "Spawn.SuccessOther";
        MessageBuilder.command(messagePath, commandSender).target(targetPlayer.getName()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("Spawn.Success", targetUser).sender(commandSender.getName().get()).build();
    }

    private void handleSetSpawnCommand(User commandSender, String label) {
        if (!this.checkBasePermission(commandSender, "Spawn.Set")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        Location currentLocation = commandSender.getPlayer().getLocation();
        this.spawnConfiguration.set("Spawn.World", (Object)currentLocation.getWorld().getName());
        this.spawnConfiguration.set("Spawn.X", (Object)currentLocation.getX());
        this.spawnConfiguration.set("Spawn.Y", (Object)currentLocation.getY());
        this.spawnConfiguration.set("Spawn.Z", (Object)currentLocation.getZ());
        this.spawnConfiguration.set("Spawn.Yaw", (Object)Float.valueOf(currentLocation.getYaw()));
        this.spawnConfiguration.set("Spawn.Pitch", (Object)Float.valueOf(currentLocation.getPitch()));
        try {
            this.spawnConfiguration.save(this._spawnFile);
        }
        catch (IOException exception) {
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).build();
            ServerSystem.getLog().log(Level.SEVERE, "Error while saving 'spawn.yml'", exception);
            return;
        }
        this.spawnLocation = Optional.of(currentLocation);
        MessageBuilder.command("SetSpawn.Success", commandSender).build();
    }

    private void saveDefaultConfig() {
        if (this._spawnFile.exists()) {
            return;
        }
        try {
            this._spawnFile.createNewFile();
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while trying to create 'spawn.yml' file", exception);
        }
        this.spawnConfiguration.set("Config.TeleportOnJoin", (Object)true);
        this.spawnConfiguration.set("Config.TeleportOnFirstJoin", (Object)true);
        try {
            this.spawnConfiguration.save(this._spawnFile);
        }
        catch (IOException exception) {
            throw new RuntimeException("Error while trying to spawn 'spawn.yml'", exception);
        }
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Spawn";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        if (command.getName().equalsIgnoreCase("spawn")) {
            return PermissionManager.hasCommandPermission((CommandSender)player, "Spawn.Use", false);
        }
        return PermissionManager.hasCommandPermission((CommandSender)player, "Spawn.Set", false);
    }
}

