/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.teleport;

import java.text.DecimalFormat;
import java.util.Optional;
import java.util.function.Consumer;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

@ServerSystemCommand(name="teleport", variants={"teleportposition", "teleporthere", "teleportall"})
public class CommandTeleport
extends AbstractServerSystemCommand {
    private static final Vector _X_AXIS = new Vector(1, 0, 0);
    private static final Vector _Y_AXIS = new Vector(0, 1, 0);
    private static final Vector _Z_AXIS = new Vector(0, 0, 1);

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        String commandName;
        switch (commandName = command.getName().toLowerCase()) {
            case "teleportposition": {
                this.executeTeleportPosition(commandSender, command, label, arguments);
                break;
            }
            case "teleporthere": {
                this.executeTeleportHere(commandSender, command, label, arguments);
                break;
            }
            case "teleportall": {
                this.executeTeleportAll(commandSender);
                break;
            }
            default: {
                if (arguments.length == 2) {
                    this.executeTeleportOther(commandSender, command, label, arguments);
                    break;
                }
                if (arguments.length > 2) {
                    this.executeTeleportPosition(commandSender, command, label, arguments);
                    break;
                }
                this.executeTeleport(commandSender, arguments);
            }
        }
    }

    private void executeTeleportAll(User commandSender) {
        if (!this.validateSenderAndPermission(commandSender, "TeleportAll.Use")) {
            return;
        }
        Location senderLocation = commandSender.getPlayer().getLocation();
        Bukkit.getOnlinePlayers().forEach(player -> player.teleport(senderLocation));
        MessageBuilder.command("TeleportAll.Success", commandSender).target("*").build();
    }

    private void executeTeleportHere(User commandSender, Command command, String label, String[] arguments) {
        if (!this.validateSenderAndPermission(commandSender, "TeleportHere.Use")) {
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        this.getTargetUserAndTeleport(commandSender, arguments, targetPlayer -> targetPlayer.teleport(commandSender.getPlayer().getLocation()), "TeleportHere.Success");
    }

    private void executeTeleport(User commandSender, String[] arguments) {
        if (!this.validateSenderAndPermission(commandSender, "Teleport.Use")) {
            return;
        }
        this.getTargetUserAndTeleport(commandSender, arguments, targetPlayer -> commandSender.getPlayer().teleport(targetPlayer.getLocation()), "Teleport.Success");
    }

    private void executeTeleportOther(User commandSender, Command command, String label, String[] arguments) {
        if (!this.validatePermissions(commandSender, "Teleport.Use", "Teleport.Other")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, 1, arguments)) {
            return;
        }
        Optional<User> sourceUserOpt = this.getTargetUser(commandSender, arguments);
        Optional<User> targetUserOpt = this.getTargetUser(commandSender, 1, false, arguments);
        if (sourceUserOpt.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        if (targetUserOpt.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[1]).build();
            return;
        }
        Player sourcePlayer = sourceUserOpt.get().getPlayer();
        Player targetPlayer = targetUserOpt.get().getPlayer();
        sourcePlayer.teleport(targetPlayer.getLocation());
        MessageBuilder.command("Teleport.SuccessOther", commandSender).target(sourcePlayer.getName()).postModifier(message -> message.replace("<TARGET2>", targetPlayer.getName())).build();
    }

    private void executeTeleportPosition(User commandSender, Command command, String label, String[] arguments) {
        Optional<User> targetUserOpt;
        Optional<User> potentialTargetUser;
        if (!this.validatePermissions(commandSender, "TeleportPosition.Use")) {
            return;
        }
        if (arguments.length < 3) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        boolean isSelf = true;
        int startIndex = 0;
        if (arguments.length > 3 && (potentialTargetUser = this.getTargetUser(commandSender, arguments)).isPresent()) {
            isSelf = false;
            startIndex = 1;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, 3, arguments)) {
            return;
        }
        Optional<User> optional = targetUserOpt = isSelf ? Optional.of(commandSender) : this.getTargetUser(commandSender, arguments);
        if (targetUserOpt.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOpt.get();
        Player targetPlayer = targetUser.getPlayer();
        if (!isSelf && !this.checkOtherPermission(commandSender, "TeleportPosition.Other", targetPlayer.getName())) {
            return;
        }
        Location executionLocation = commandSender instanceof ConsoleUser ? targetPlayer.getLocation() : commandSender.getPlayer().getLocation();
        Optional<Location> locationOpt = this.extractLocationWithRotation(executionLocation, (Entity)targetPlayer, arguments, startIndex);
        if (locationOpt.isEmpty()) {
            MessageBuilder.command("TeleportPosition.InvalidLocation", commandSender).target(targetPlayer.getName()).build();
            return;
        }
        Location location = locationOpt.get();
        if (!this.isValidTeleportLocation(location, commandSender, targetPlayer)) {
            return;
        }
        targetPlayer.teleport(location);
        this.sendTeleportPositionSuccess(commandSender, targetPlayer, location, isSelf);
    }

    private boolean isValidTeleportLocation(Location location, User commandSender, Player targetPlayer) {
        if (!location.getWorld().getWorldBorder().isInside(location)) {
            MessageBuilder.command("TeleportPosition.OutsideBorder", commandSender).target(targetPlayer.getName()).build();
            return false;
        }
        return location.getWorld() == targetPlayer.getWorld() || this.checkBasePermission(commandSender, "TeleportPosition.World");
    }

    private void sendTeleportPositionSuccess(User commandSender, Player targetPlayer, Location location, boolean isSelf) {
        String messagePath = isSelf ? "TeleportPosition.Success" : "TeleportPosition.SuccessOther";
        MessageBuilder.command(messagePath, commandSender).target(targetPlayer.getName()).postModifier(message -> this.formatLocationMessage((String)message, location)).build();
    }

    private String formatLocationMessage(String message, Location location) {
        return message.replace("<X>", this.roundDecimal(location.getX())).replace("<Y>", this.roundDecimal(location.getY())).replace("<Z>", this.roundDecimal(location.getZ())).replace("<WORLD>", location.getWorld().getName());
    }

    private boolean validateSenderAndPermission(User commandSender, String permission) {
        if (!this.checkBasePermission(commandSender, permission)) {
            return false;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return false;
        }
        return true;
    }

    private boolean validatePermissions(User commandSender, String ... permissions) {
        for (String permission : permissions) {
            if (this.checkBasePermission(commandSender, permission)) continue;
            return false;
        }
        return true;
    }

    private void getTargetUserAndTeleport(User commandSender, String[] arguments, Consumer<Player> teleportAction, String successMessage) {
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        Player targetPlayer = targetUserOptional.get().getPlayer();
        teleportAction.accept(targetPlayer);
        MessageBuilder.command(successMessage, commandSender).target(targetPlayer.getName()).build();
    }

    private String roundDecimal(double location) {
        DecimalFormat format = new DecimalFormat("0.##");
        return format.format(location).replace(",", ".");
    }

    public Optional<Location> extractLocationWithRotation(Location executeLocation, Entity target, String[] arguments, int startIndex) {
        Optional<Float> pitchOpt;
        Optional<Float> yawOpt;
        int coordinateEndIndex = startIndex + 3;
        if (arguments.length < coordinateEndIndex) {
            return Optional.empty();
        }
        Optional<Double> x = this.calculateRelativePosition(_X_AXIS, arguments[startIndex], executeLocation, target.getLocation());
        Optional<Double> y = this.calculateRelativePosition(_Y_AXIS, arguments[startIndex + 1], executeLocation, target.getLocation());
        Optional<Double> z = this.calculateRelativePosition(_Z_AXIS, arguments[startIndex + 2], executeLocation, target.getLocation());
        if (x.isEmpty() || y.isEmpty() || z.isEmpty()) {
            return Optional.empty();
        }
        float yaw = target.getLocation().getYaw();
        float pitch = target.getLocation().getPitch();
        int currentIndex = coordinateEndIndex;
        if (arguments.length > currentIndex && (yawOpt = this.calculateRelativeRotation(arguments[currentIndex], executeLocation, target.getLocation(), true)).isPresent()) {
            yaw = yawOpt.get().floatValue();
            ++currentIndex;
        }
        if (arguments.length > currentIndex && (pitchOpt = this.calculateRelativeRotation(arguments[currentIndex], executeLocation, target.getLocation(), false)).isPresent()) {
            pitch = pitchOpt.get().floatValue();
            ++currentIndex;
        }
        World world = target.getWorld();
        if (arguments.length > currentIndex) {
            String worldName = arguments[currentIndex];
            World targetWorld = target.getServer().getWorld(worldName);
            if (targetWorld != null) {
                world = targetWorld;
            }
        }
        return Optional.of(new Location(world, x.get().doubleValue(), y.get().doubleValue(), z.get().doubleValue(), yaw, pitch));
    }

    private Optional<Double> calculateRelativePosition(Vector axis, String input, Location senderLocation, Location targetLocation) {
        try {
            if (input.equals("~")) {
                return Optional.of(this.getCoordinate(targetLocation, axis));
            }
            if (input.equals("@")) {
                return Optional.of(this.getCoordinate(senderLocation, axis));
            }
            if (input.startsWith("~")) {
                return Optional.of(this.parseOffset(input, targetLocation, axis, 1));
            }
            if (input.startsWith("@")) {
                return Optional.of(this.parseOffset(input, senderLocation, axis, 1));
            }
            return Optional.of(Double.parseDouble(input));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    private Optional<Float> calculateRelativeRotation(String input, Location senderLocation, Location targetLocation, boolean isYaw) {
        try {
            if (input.equals("~")) {
                return Optional.of(Float.valueOf(isYaw ? targetLocation.getYaw() : targetLocation.getPitch()));
            }
            if (input.equals("@")) {
                return Optional.of(Float.valueOf(isYaw ? senderLocation.getYaw() : senderLocation.getPitch()));
            }
            if (input.startsWith("~")) {
                return Optional.of(Float.valueOf(this.parseRotationOffset(input, targetLocation, isYaw, 1)));
            }
            if (input.startsWith("@")) {
                return Optional.of(Float.valueOf(this.parseRotationOffset(input, senderLocation, isYaw, 1)));
            }
            return Optional.of(Float.valueOf(Float.parseFloat(input)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    private float parseRotationOffset(String input, Location location, boolean isYaw, int offsetStartIndex) {
        float offset = Float.parseFloat(input.substring(offsetStartIndex));
        float currentValue = isYaw ? location.getYaw() : location.getPitch();
        return currentValue + offset;
    }

    private double parseOffset(String input, Location location, Vector axis, int offsetStartIndex) {
        double offset = Double.parseDouble(input.substring(offsetStartIndex));
        return this.getCoordinate(location, axis) + offset;
    }

    private double getCoordinate(Location location, Vector axis) {
        return axis.getX() * location.getX() + axis.getY() * location.getY() + axis.getZ() * location.getZ();
    }

    @Override
    public String getSyntaxPath(Command command) {
        String commandName;
        return switch (commandName = command.getName().toLowerCase()) {
            case "teleportposition" -> "TeleportPosition";
            case "teleporthere" -> "TeleportHere";
            case "teleportall" -> "TeleportAll";
            default -> "Teleport";
        };
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        String commandName;
        String permission = switch (commandName = command.getName().toLowerCase()) {
            case "teleportposition" -> "TeleportPosition.Use";
            case "teleporthere" -> "TeleportHere.Use";
            case "teleportall" -> "TeleportAll.Use";
            default -> "Teleport.Use";
        };
        return PermissionManager.hasCommandPermission((CommandSender)player, permission, false);
    }
}

