/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.warp;

import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.ServiceRegistry;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.warp.TabCompleterWarp;
import me.testaccount666.serversystem.commands.executables.warp.manager.Warp;
import me.testaccount666.serversystem.commands.executables.warp.manager.WarpManager;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="warp", variants={"setwarp", "deletewarp"}, tabCompleter=TabCompleterWarp.class)
public class CommandWarp
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (arguments.length == 0) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        switch (command.getName().toLowerCase()) {
            case "warp": {
                this.handleWarpCommand(commandSender, arguments);
                break;
            }
            case "setwarp": {
                this.handleSetWarpCommand(commandSender, arguments);
                break;
            }
            case "deletewarp": {
                this.handleDeleteWarpCommand(commandSender, arguments);
            }
        }
    }

    private void handleWarpCommand(User commandSender, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Warp.Use")) {
            return;
        }
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        WarpManager warpManager = registry.getService(WarpManager.class);
        Optional<Warp> warpOptional = warpManager.getWarpByName(arguments[0]);
        if (warpOptional.isEmpty()) {
            MessageBuilder.command("Warp.WarpNotFound", commandSender).postModifier(message -> message.replace("<WARP>", arguments[0])).build();
            return;
        }
        Warp warp = warpOptional.get();
        Player player = commandSender.getPlayer();
        this.playAnimation(player.getLocation());
        player.teleport(warp.getLocation());
        this.playAnimation(player.getLocation());
        MessageBuilder.command("Warp.Success", commandSender).postModifier(message -> message.replace("<WARP>", warp.getDisplayName())).build();
    }

    private void handleSetWarpCommand(User commandSender, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Warp.Set")) {
            return;
        }
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        WarpManager warpManager = registry.getService(WarpManager.class);
        String warpName = arguments[0];
        Location warpLocation = commandSender.getPlayer().getLocation();
        Optional<Warp> warpOptional = warpManager.getWarpByName(warpName);
        if (warpOptional.isPresent()) {
            MessageBuilder.command("Warp.Set.WarpAlreadyExists", commandSender).postModifier(message -> message.replace("<WARP>", arguments[0])).build();
            return;
        }
        Warp warp = warpManager.addWarp(warpName, warpLocation);
        MessageBuilder.command("Warp.Set.Success", commandSender).postModifier(message -> message.replace("<WARP>", warp.getDisplayName())).build();
    }

    private void handleDeleteWarpCommand(User commandSender, String ... arguments) {
        String warpName;
        if (!this.checkBasePermission(commandSender, "Warp.Delete")) {
            return;
        }
        ServiceRegistry registry = ServerSystem.Instance.getRegistry();
        WarpManager warpManager = registry.getService(WarpManager.class);
        Optional<Warp> warpOptional = warpManager.getWarpByName(warpName = arguments[0]);
        if (warpOptional.isEmpty()) {
            MessageBuilder.command("Warp.WarpNotFound", commandSender).postModifier(message -> message.replace("<WARP>", warpName)).build();
            return;
        }
        Warp warp = warpOptional.get();
        warpManager.removeWarp(warp);
        MessageBuilder.command("Warp.Delete.Success", commandSender).postModifier(message -> message.replace("<WARP>", warp.getDisplayName())).build();
    }

    private void playAnimation(Location location) {
        location.getWorld().playSound(location, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        location.getWorld().spawnParticle(Particle.PORTAL, location, 100, 0.5, 0.5, 0.5, 0.05);
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Warp";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        String permissionPath = switch (command.getName().toLowerCase()) {
            case "warp" -> "Warp.Use";
            case "setwarp" -> "Warp.Set";
            case "deletewarp" -> "Warp.Delete";
            default -> null;
        };
        return PermissionManager.hasCommandPermission((CommandSender)player, permissionPath, false);
    }
}

