/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.management;

import java.lang.invoke.CallSite;
import java.util.Map;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.management.CommandManager;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.config.ConfigurationManager;
import me.testaccount666.serversystem.utils.tuples.Tuple;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class CommandReplacer {
    public void replaceCommands() {
        ConfigurationManager configManager = ServerSystem.Instance.getRegistry().getService(ConfigurationManager.class);
        ConfigReader replaceConfig = configManager.getCommandReplaceConfig();
        if (!replaceConfig.getBoolean("ReplacedCommands.Enabled")) {
            return;
        }
        ConfigurationSection replaceSection = replaceConfig.getConfigurationSection("ReplacedCommands.Replace");
        if (replaceSection == null) {
            return;
        }
        for (String identifier : replaceSection.getKeys(false)) {
            ConfigurationSection section = replaceSection.getConfigurationSection(identifier);
            if (section == null) {
                ServerSystem.getLog().warning("Invalid command replacement identifier '" + identifier + "' in config.yml (Found no section?!)");
                continue;
            }
            Tuple<Boolean, String> result = this.replaceCommands(identifier, section);
            if (result.first().booleanValue()) {
                ServerSystem.getLog().info(result.second());
                continue;
            }
            ServerSystem.getLog().warning(result.second());
        }
        CommandManager commandManager = ServerSystem.Instance.getRegistry().getService(CommandManager.class);
        commandManager.syncCommands();
    }

    private Tuple<Boolean, String> replaceCommands(String identifier, ConfigurationSection section) {
        CommandManager commandManager = ServerSystem.Instance.getRegistry().getService(CommandManager.class);
        String fromCommandName = section.getString("From.Command");
        if (fromCommandName == null) {
            return new Tuple<Boolean, CallSite>(false, (CallSite)((Object)("Invalid command replacement with identifier '" + identifier + "': 'From Command' is null!")));
        }
        String fromPluginName = section.getString("From.Plugin");
        if (fromPluginName == null) {
            return new Tuple<Boolean, CallSite>(false, (CallSite)((Object)("Invalid command replacement with identifier '" + identifier + "': 'From Plugin' is null!")));
        }
        Tuple<Boolean, String> fromPluginResult = this.verifyPlugin(fromPluginName);
        if (!fromPluginResult.first().booleanValue()) {
            return new Tuple<Boolean, CallSite>(false, (CallSite)((Object)("Invalid command replacement with identifier '" + identifier + "': " + fromPluginResult.second() + " (FromPlugin)")));
        }
        Optional<Command> fromCommand = commandManager.getCommand(fromPluginName.toLowerCase() + ":" + fromCommandName.toLowerCase());
        if (fromCommand.isEmpty()) {
            return new Tuple<Boolean, CallSite>(false, (CallSite)((Object)("Invalid command replacement with identifier '" + identifier + "': " + fromPluginName + ":" + fromCommandName + " (Command not found in plugin '" + fromPluginName + "')")));
        }
        String toCommandName = section.getString("To.Command");
        if (toCommandName == null) {
            return new Tuple<Boolean, CallSite>(false, (CallSite)((Object)("Invalid command replacement with identifier '" + identifier + "': 'To Command' is null!")));
        }
        Optional<Command> toCommand = commandManager.getCommand(toCommandName.toLowerCase());
        if (toCommand.isEmpty()) {
            return new Tuple<Boolean, CallSite>(false, (CallSite)((Object)("Invalid command replacement with identifier '" + identifier + "': " + toCommandName + " (Command not found!)")));
        }
        Map<String, Command> commandMap = commandManager.getCommandMap();
        commandMap.remove(toCommandName.toLowerCase());
        commandMap.put(toCommandName.toLowerCase(), fromCommand.get());
        return new Tuple<Boolean, CallSite>(true, (CallSite)((Object)("Replaced command '" + toCommandName + "' with '" + fromPluginName + ":" + fromCommandName + "'")));
    }

    private Tuple<Boolean, String> verifyPlugin(String pluginName) {
        PluginManager pluginManager = Bukkit.getPluginManager();
        Plugin plugin = pluginManager.getPlugin(pluginName);
        if (plugin == null) {
            return new Tuple<Boolean, CallSite>(false, (CallSite)((Object)("Invalid plugin name '" + pluginName + "' (Plugin not found!)")));
        }
        if (!plugin.isEnabled()) {
            return new Tuple<Boolean, CallSite>(false, (CallSite)((Object)("Invalid plugin name '" + pluginName + "' (Plugin is not enabled!)")));
        }
        return new Tuple<Boolean, Object>(true, null);
    }
}

