/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.wrappers;

import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.commands.wrappers.AbstractCommandWrapper;
import me.testaccount666.serversystem.userdata.User;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class CommandExecutorWrapper
extends AbstractCommandWrapper
implements CommandExecutor {
    private final ServerSystemCommandExecutor _commandExecutor;

    public CommandExecutorWrapper(ServerSystemCommandExecutor commandExecutor) {
        this._commandExecutor = commandExecutor;
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] arguments) {
        Optional<User> commandUser = CommandExecutorWrapper.resolveCommandUser(commandSender);
        if (commandUser.isEmpty()) {
            ServerSystem.getLog().severe("Error executing command '" + command.getName() + "'. CommandSender '" + commandSender.getName() + "' is not a valid user?!");
            return false;
        }
        this._commandExecutor.execute(commandUser.get(), command, label, arguments);
        return true;
    }

    public ServerSystemCommandExecutor getCommandExecutor() {
        return this._commandExecutor;
    }
}

