/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.listener.executables.clientlanguagechecker;

import com.destroystokyo.paper.ClientOption;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.config.ConfigurationManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class ListenerClientLanguageChecker
implements Listener {
    private boolean _useClientLanguage;

    public ListenerClientLanguageChecker() {
        ConfigurationManager configManager = ServerSystem.Instance.getRegistry().getService(ConfigurationManager.class);
        this._useClientLanguage = configManager.getGeneralConfig().getBoolean("Language.UseClientLanguage", false);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Optional<CachedUser> userOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(event.getPlayer());
        if (userOptional.isEmpty()) {
            return;
        }
        CachedUser cachedUser = userOptional.get();
        if (cachedUser.isOfflineUser()) {
            return;
        }
        User user = (User)cachedUser.getOfflineUser();
        if (!user.isUsesDefaultLanguage()) {
            return;
        }
        if (!this._useClientLanguage) {
            return;
        }
        String locale = (String)event.getPlayer().getClientOption(ClientOption.LOCALE);
        String language = "English";
        if (locale.startsWith("en_")) {
            language = "English";
        }
        if (locale.startsWith("de_")) {
            language = "German";
        }
        if (locale.startsWith("sl_")) {
            language = "Slovene";
        }
        user.setPlayerLanguage(language.toLowerCase());
    }
}

