/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.listener.executables.joinquitnotifier;

import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.config.ConfigurationManager;
import me.testaccount666.serversystem.managers.messages.MessageManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.UserManager;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class ListenerQuit
implements Listener {
    private final boolean _modifyMessage;
    private final boolean _sendMessage;
    private final String _message;
    private boolean _playSound;
    private Sound _sound;

    public ListenerQuit() {
        NamespacedKey soundKey;
        ConfigurationManager configManager = ServerSystem.Instance.getRegistry().getService(ConfigurationManager.class);
        ConfigReader config = configManager.getGeneralConfig();
        this._modifyMessage = config.getBoolean("Quit.Message.Enabled");
        this._sendMessage = config.getBoolean("Quit.Message.SendMessage");
        this._message = config.getString("Quit.Message.Message", "");
        this._playSound = config.getBoolean("Quit.Sound.Enabled");
        if (!this._playSound) {
            this._sound = null;
            return;
        }
        String soundString = config.getString("Quit.Sound.Sound", "");
        boolean isMinecraft = true;
        if (soundString.contains(":")) {
            String space = soundString.substring(0, soundString.indexOf(":"));
            soundString = soundString.substring(soundString.indexOf(":") + 1);
            isMinecraft = space.equalsIgnoreCase("minecraft");
        }
        NamespacedKey namespacedKey = soundKey = isMinecraft ? NamespacedKey.minecraft((String)soundString) : NamespacedKey.fromString((String)soundString);
        if (soundKey == null) {
            this._playSound = false;
            ServerSystem.getLog().warning("Failed to parse sound '" + soundString + "' for quit message!");
            return;
        }
        this._sound = (Sound)Registry.SOUND_EVENT.get(soundKey);
        if (this._sound == null) {
            this._playSound = false;
            ServerSystem.getLog().warning("Failed to find sound '" + soundString + "' for quit message!");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerQuitEvent event) {
        this.handleMessage(event);
        this.playSound();
    }

    private void playSound() {
        if (!this._playSound) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(everyone -> everyone.playSound((Entity)everyone, this._sound, 1.0f, 1.0f));
    }

    private void handleMessage(PlayerQuitEvent event) {
        if (!this._modifyMessage) {
            return;
        }
        if (!this._sendMessage) {
            event.setQuitMessage(null);
            return;
        }
        Player player = event.getPlayer();
        Optional<CachedUser> userOptional = ServerSystem.Instance.getRegistry().getService(UserManager.class).getUser(player);
        if (userOptional.isEmpty()) {
            ServerSystem.getLog().warning("Couldn't cache User '" + player.getName() + "'! This should not happen!");
            return;
        }
        CachedUser cachedUser = userOptional.get();
        if (cachedUser.isOfflineUser()) {
            ServerSystem.getLog().warning("User '" + player.getName() + "' is cached as Offline User! This should not happen!");
            return;
        }
        User user = (User)cachedUser.getOfflineUser();
        String message = MessageManager.formatMessage(this._message, user, null, null, false);
        event.setQuitMessage(message);
    }
}

