/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.config.DefaultConfigReader;
import me.testaccount666.serversystem.managers.config.NonValidatingConfigReader;
import me.testaccount666.serversystem.managers.globaldata.DefaultsData;
import me.testaccount666.serversystem.managers.messages.MappingsData;
import me.testaccount666.serversystem.managers.messages.MessageManager;
import org.bukkit.plugin.Plugin;

public class ConfigurationManager {
    private final Plugin _plugin;
    private final Path _pluginFolder;
    ConfigReader _generalConfig;
    private ConfigReader _commandsConfig;
    private ConfigReader _economyConfig;
    private ConfigReader _moderationConfig;
    private ConfigReader _commandReplaceConfig;

    public ConfigurationManager(Plugin plugin) {
        this._plugin = plugin;
        this._pluginFolder = Path.of("plugins", "ServerSystem");
    }

    public void loadAllConfigs() throws FileNotFoundException {
        this.initializeGeneralConfig();
        this.initializeCommandsConfig();
        this.initializePermissionsConfig();
        this.initializeMappingsData();
        this.initializeDefaultsConfig();
        this.initializeMessagesConfig();
        this.initializeEconomyConfig();
        this.initializeModerationConfig();
        this.initializeCommandReplaceConfig();
        this.createUserDataFolder();
    }

    private void initializeMappingsData() {
        new MappingsData();
    }

    private void initializeGeneralConfig() throws FileNotFoundException {
        this._plugin.saveDefaultConfig();
        File generalFile = this._pluginFolder.resolve("config.yml").toFile();
        this._generalConfig = new DefaultConfigReader(generalFile, this._plugin);
    }

    private void initializeCommandsConfig() throws FileNotFoundException {
        File commandsFile = this._pluginFolder.resolve("commands.yml").toFile();
        this.ensureConfigFileExists(commandsFile, "commands.yml");
        this._commandsConfig = new DefaultConfigReader(commandsFile, this._plugin);
    }

    private void initializePermissionsConfig() throws FileNotFoundException {
        File permissionsFile = this._pluginFolder.resolve("permissions.yml").toFile();
        this.ensureConfigFileExists(permissionsFile, "permissions.yml");
        PermissionManager.initialize(this._plugin);
    }

    private void initializeMessagesConfig() throws FileNotFoundException {
        MessageManager.initialize();
    }

    private void initializeDefaultsConfig() throws FileNotFoundException {
        File defaultsFile = this._pluginFolder.resolve("defaults.yml").toFile();
        this.ensureConfigFileExists(defaultsFile, "defaults.yml");
        DefaultsData.initialize(new DefaultConfigReader(defaultsFile, this._plugin));
    }

    private void initializeEconomyConfig() throws FileNotFoundException {
        File economyFile = this._pluginFolder.resolve("economy.yml").toFile();
        this.ensureConfigFileExists(economyFile, "economy.yml");
        this._economyConfig = new DefaultConfigReader(economyFile, this._plugin);
    }

    private void initializeModerationConfig() throws FileNotFoundException {
        File moderationFile = this._pluginFolder.resolve("moderation.yml").toFile();
        this.ensureConfigFileExists(moderationFile, "moderation.yml");
        this._moderationConfig = new DefaultConfigReader(moderationFile, this._plugin);
    }

    private void initializeCommandReplaceConfig() throws FileNotFoundException {
        File replacedCommandsFile = this._pluginFolder.resolve("replacedCommands.yml").toFile();
        this.ensureConfigFileExists(replacedCommandsFile, "replacedCommands.yml");
        this._commandReplaceConfig = new NonValidatingConfigReader(replacedCommandsFile, this._plugin);
    }

    private void createUserDataFolder() {
        File userDataFolder = this._pluginFolder.resolve("UserData").toFile();
        if (!userDataFolder.exists()) {
            userDataFolder.mkdirs();
        }
    }

    private void ensureConfigFileExists(File configFile, String resourceName) {
        if (!configFile.exists()) {
            this._plugin.saveResource(resourceName, false);
        }
    }

    public ConfigReader getGeneralConfig() {
        return this._generalConfig;
    }

    public ConfigReader getCommandsConfig() {
        return this._commandsConfig;
    }

    public ConfigReader getEconomyConfig() {
        return this._economyConfig;
    }

    public ConfigReader getModerationConfig() {
        return this._moderationConfig;
    }

    public ConfigReader getCommandReplaceConfig() {
        return this._commandReplaceConfig;
    }
}

