/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.database;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.config.ConfigReader;

public abstract class AbstractDatabaseManager {
    protected final ConfigReader configReader;
    protected final String databaseType;
    protected HikariDataSource dataSource;

    public AbstractDatabaseManager(ConfigReader configReader, String databaseType) {
        this.configReader = configReader;
        this.databaseType = databaseType;
    }

    public void initialize() {
        try {
            this.initializeConnection();
            this.createTablesIfNotExist();
        }
        catch (SQLException exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to initialize " + this.databaseType + " database", exception);
        }
    }

    protected abstract void initializeConnection() throws SQLException;

    protected abstract void createTablesIfNotExist() throws SQLException;

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null || this.dataSource.isClosed()) {
            this.initializeConnection();
        }
        return this.dataSource.getConnection();
    }

    public void shutdown() {
        try {
            if (this.dataSource != null && !this.dataSource.isClosed()) {
                this.dataSource.close();
                ServerSystem.getLog().info(this.databaseType + " database connection pool closed.");
            }
        }
        catch (Exception exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Error closing " + this.databaseType + " database connection pool", exception);
        }
    }
}

