/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.database.economy;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.database.HikariConfigUtil;
import me.testaccount666.serversystem.managers.database.economy.AbstractEconomyDatabaseManager;

public class SqliteEconomyDatabaseManager
extends AbstractEconomyDatabaseManager {
    private final File _databaseFile;

    public SqliteEconomyDatabaseManager(File dataFolder) {
        super(null);
        this._databaseFile = Path.of(dataFolder.getPath(), "data", "economy.db").toFile();
    }

    @Override
    public void initialize() {
        try {
            if (!this._databaseFile.getParentFile().exists()) {
                this._databaseFile.getParentFile().mkdirs();
            }
            super.initialize();
        }
        catch (Exception exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Failed to initialize SQLite economy database", exception);
        }
    }

    @Override
    protected void initializeConnection() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            return;
        }
        HikariConfig config = HikariConfigUtil.configureSqlite(this._databaseFile, "economy-sqlite-pool");
        this.dataSource = new HikariDataSource(config);
        ServerSystem.getLog().info("Successfully initialized SQLite connection pool for economy.");
    }

    @Override
    protected void createTablesIfNotExist() throws SQLException {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("    CREATE TABLE IF NOT EXISTS Economy (\n        Owner VARCHAR(36) NOT NULL,\n        Balance DECIMAL(65,2) NOT NULL,\n        AccountId VARCHAR(36) NOT NULL,\n        PRIMARY KEY (Owner, AccountId)\n    )\n");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_owner ON Economy (Owner)");
            statement.execute("CREATE INDEX IF NOT EXISTS idx_account_id ON Economy (AccountId)");
        }
    }
}

