/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.messages;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.executables.back.CommandBack;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.messages.MessageManager;
import me.testaccount666.serversystem.userdata.OfflineUser;

public class MappingsData {
    private static MappingsData _Instance;
    private final Map<String, GameMode> _gameModeByLanguage = new HashMap<String, GameMode>();
    private final Map<String, MessageColors> _messageColorsByLanguage = new HashMap<String, MessageColors>();
    private final Map<String, BackType> _backTypeByLanguage = new HashMap<String, BackType>();
    private final Map<String, Moderation> _moderationByLanguage = new HashMap<String, Moderation>();
    private final Map<String, Console> _consoleByLanguage = new HashMap<String, Console>();

    public MappingsData() {
        _Instance = this;
    }

    private static <T> T getOrLoadMappingData(OfflineUser user, Map<String, T> cache, Function<ConfigReader, T> factory) {
        String language = user.getPlayerLanguage();
        return MappingsData.getOrLoadMappingData(language, cache, factory);
    }

    private static <T> T getOrLoadMappingData(String language, Map<String, T> cache, Function<ConfigReader, T> factory) {
        T data = cache.get(language);
        if (data != null) {
            return data;
        }
        Optional<ConfigReader> readerOptional = MessageManager.getLanguageLoader().getMappingReader(language);
        if (readerOptional.isPresent()) {
            data = factory.apply(readerOptional.get());
            cache.put(language, data);
            return data;
        }
        String defaultLanguage = MessageManager.getDefaultLanguage();
        readerOptional = MessageManager.getLanguageLoader().getMappingReader(defaultLanguage);
        data = factory.apply(readerOptional.get());
        cache.put(language, data);
        return data;
    }

    @Deprecated(forRemoval=true, since="3.3.0")
    public static GameMode gameMode() {
        String defaultLanguage = MessageManager.getDefaultLanguage();
        return MappingsData.getOrLoadMappingData(defaultLanguage, MappingsData._Instance._gameModeByLanguage, GameMode::new);
    }

    @Deprecated(forRemoval=true, since="3.3.0")
    public static MessageColors messageColors() {
        String defaultLanguage = MessageManager.getDefaultLanguage();
        return MappingsData.getOrLoadMappingData(defaultLanguage, MappingsData._Instance._messageColorsByLanguage, MessageColors::new);
    }

    @Deprecated(forRemoval=true, since="3.3.0")
    public static BackType backType() {
        String defaultLanguage = MessageManager.getDefaultLanguage();
        return MappingsData.getOrLoadMappingData(defaultLanguage, MappingsData._Instance._backTypeByLanguage, BackType::new);
    }

    @Deprecated(forRemoval=true, since="3.3.0")
    public static Moderation moderation() {
        String defaultLanguage = MessageManager.getDefaultLanguage();
        return MappingsData.getOrLoadMappingData(defaultLanguage, MappingsData._Instance._moderationByLanguage, Moderation::new);
    }

    @Deprecated(forRemoval=true, since="3.3.0")
    public static Console console() {
        String defaultLanguage = MessageManager.getDefaultLanguage();
        return MappingsData.getOrLoadMappingData(defaultLanguage, MappingsData._Instance._consoleByLanguage, Console::new);
    }

    public static Moderation moderation(OfflineUser user) {
        return MappingsData.getOrLoadMappingData(user, MappingsData._Instance._moderationByLanguage, Moderation::new);
    }

    public static Console console(OfflineUser user) {
        return MappingsData.getOrLoadMappingData(user, MappingsData._Instance._consoleByLanguage, Console::new);
    }

    public static GameMode gameMode(OfflineUser user) {
        return MappingsData.getOrLoadMappingData(user, MappingsData._Instance._gameModeByLanguage, GameMode::new);
    }

    public static MessageColors messageColors(OfflineUser user) {
        return MappingsData.getOrLoadMappingData(user, MappingsData._Instance._messageColorsByLanguage, MessageColors::new);
    }

    public static BackType backType(OfflineUser user) {
        return MappingsData.getOrLoadMappingData(user, MappingsData._Instance._backTypeByLanguage, BackType::new);
    }

    public static MappingsData instance() {
        return _Instance;
    }

    public static class GameMode {
        private final Map<org.bukkit.GameMode, String> _gameModeMappings = new HashMap<org.bukkit.GameMode, String>();

        public GameMode(ConfigReader config) {
            for (org.bukkit.GameMode gameMode : org.bukkit.GameMode.values()) {
                String gameModeName = config.getString("Mappings.GameMode." + gameMode.name().toLowerCase());
                if (gameModeName == null) {
                    ServerSystem.getLog().warning("GameMode mapping for '" + gameMode.name() + "' is not defined in the config!");
                    continue;
                }
                this._gameModeMappings.put(gameMode, gameModeName);
            }
        }

        public Optional<String> getGameModeName(org.bukkit.GameMode gameMode) {
            return Optional.ofNullable(this._gameModeMappings.getOrDefault(gameMode, null));
        }

        public Set<String> getGameModeNames() {
            return new HashSet<String>(this._gameModeMappings.values());
        }
    }

    public static class MessageColors {
        private final Map<String, String> _messageColorMappings = new HashMap<String, String>();

        public MessageColors(ConfigReader config) {
            String prefixColor = config.getString("Mappings.MessageColors.prefix");
            String separatorColor = config.getString("Mappings.MessageColors.separators");
            String messageColor = config.getString("Mappings.MessageColors.message");
            String highlightColor = config.getString("Mappings.MessageColors.highlight");
            String errorMessageColor = config.getString("Mappings.MessageColors.error.message");
            String errorHighlightColor = config.getString("Mappings.MessageColors.error.highlight");
            this._messageColorMappings.put("Prefix", prefixColor);
            this._messageColorMappings.put("Separator", separatorColor);
            this._messageColorMappings.put("Message", messageColor);
            this._messageColorMappings.put("Highlight", highlightColor);
            this._messageColorMappings.put("ErrorMessage", errorMessageColor);
            this._messageColorMappings.put("ErrorHighlight", errorHighlightColor);
        }

        public Optional<String> getMessageColor(String colorId) {
            return Optional.ofNullable(this._messageColorMappings.getOrDefault(colorId, null));
        }
    }

    public static class BackType {
        private final Map<CommandBack.BackType, String> _backTypeMappings = new HashMap<CommandBack.BackType, String>();

        public BackType(ConfigReader config) {
            for (CommandBack.BackType backType : CommandBack.BackType.values()) {
                String backTypeName = config.getString("Mappings.BackType." + backType.name().toLowerCase());
                if (backTypeName == null) {
                    ServerSystem.getLog().warning("BackType mapping for '" + backType.name() + "' is not defined in the config!");
                    continue;
                }
                this._backTypeMappings.put(backType, backTypeName);
            }
        }

        public Optional<String> getBackTypeName(CommandBack.BackType backType) {
            return Optional.ofNullable(this._backTypeMappings.getOrDefault((Object)backType, null));
        }
    }

    public static class Moderation {
        private final Map<String, String> _moderationMappings = new HashMap<String, String>();

        public Moderation(ConfigReader config) {
            String neverName = config.getString("Mappings.Moderation.Permanent");
            if (neverName == null) {
                ServerSystem.getLog().warning("Moderation mapping for 'Permanent' is not defined in the config!");
                return;
            }
            this._moderationMappings.put("permanent", neverName);
        }

        public Optional<String> getName(String key) {
            return Optional.ofNullable(this._moderationMappings.getOrDefault(key, null));
        }
    }

    public static class Console {
        private final Map<String, String> _consoleMappings = new HashMap<String, String>();

        public Console(ConfigReader config) {
            String neverName = config.getString("Mappings.Console.Name");
            if (neverName == null) {
                ServerSystem.getLog().warning("Console mapping for 'Name' is not defined in the config!");
                return;
            }
            this._consoleMappings.put("name", neverName);
        }

        public Optional<String> getName(String key) {
            return Optional.ofNullable(this._consoleMappings.getOrDefault(key, null));
        }
    }
}

