/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.moderation;

import java.util.UUID;

public abstract class AbstractModeration {
    private final long _issueTime;
    private final long _expireTime;
    private final String _reason;
    private final UUID _senderUuid;
    private final UUID _targetUuid;

    public AbstractModeration(long issueTime, long expireTime, String reason, UUID senderUuid, UUID targetUuid) {
        this._issueTime = issueTime;
        this._expireTime = expireTime;
        this._reason = reason;
        this._senderUuid = senderUuid;
        this._targetUuid = targetUuid;
    }

    public boolean isExpired() {
        if (this._expireTime == -1L) {
            return false;
        }
        return System.currentTimeMillis() >= this._expireTime;
    }

    protected AbstractModeration(AbstractModerationBuilder<?, ?> b) {
        this._issueTime = b.issueTime;
        this._expireTime = b.expireTime;
        this._reason = b.reason;
        this._senderUuid = b.senderUuid;
        this._targetUuid = b.targetUuid;
    }

    public long issueTime() {
        return this._issueTime;
    }

    public long expireTime() {
        return this._expireTime;
    }

    public String reason() {
        return this._reason;
    }

    public UUID senderUuid() {
        return this._senderUuid;
    }

    public UUID targetUuid() {
        return this._targetUuid;
    }

    public static abstract class AbstractModerationBuilder<C extends AbstractModeration, B extends AbstractModerationBuilder<C, B>> {
        private long issueTime;
        private long expireTime;
        private String reason;
        private UUID senderUuid;
        private UUID targetUuid;

        public B issueTime(long issueTime) {
            this.issueTime = issueTime;
            return this.self();
        }

        public B expireTime(long expireTime) {
            this.expireTime = expireTime;
            return this.self();
        }

        public B reason(String reason) {
            this.reason = reason;
            return this.self();
        }

        public B senderUuid(UUID senderUuid) {
            this.senderUuid = senderUuid;
            return this.self();
        }

        public B targetUuid(UUID targetUuid) {
            this.targetUuid = targetUuid;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AbstractModeration.AbstractModerationBuilder(issueTime=" + this.issueTime + ", expireTime=" + this.expireTime + ", reason=" + this.reason + ", senderUuid=" + String.valueOf(this.senderUuid) + ", targetUuid=" + String.valueOf(this.targetUuid) + ")";
        }
    }
}

