/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.updates;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.config.ConfigurationManager;
import me.testaccount666.serversystem.updates.AbstractUpdateChecker;
import me.testaccount666.serversystem.updates.UpdateCheckerType;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public final class UpdateManager {
    private final ServerSystem _plugin;
    private final ConfigurationManager _configManager;
    private AbstractUpdateChecker _updateChecker;

    public UpdateManager(ServerSystem plugin, ConfigurationManager configManager) {
        this._plugin = plugin;
        this._configManager = configManager;
    }

    public void start() {
        ConfigReader generalConfig = this._configManager.getGeneralConfig();
        Optional<UpdateCheckerType> updateCheckerType = this.resolveUpdateCheckerType(generalConfig);
        if (updateCheckerType.isEmpty()) {
            this.handleInvalidUpdateCheckerType(generalConfig);
            return;
        }
        this.initializeUpdateChecker(updateCheckerType.get(), generalConfig);
        this.scheduleUpdateChecks(generalConfig);
    }

    private Optional<UpdateCheckerType> resolveUpdateCheckerType(ConfigReader generalConfig) {
        String typeString = generalConfig.getString("UpdateChecker.Type.Value");
        if (typeString == null || typeString.isBlank()) {
            typeString = "DISABLED";
        }
        return UpdateCheckerType.of(typeString);
    }

    private void handleInvalidUpdateCheckerType(ConfigReader generalConfig) {
        String typeString = generalConfig.getString("UpdateChecker.Type.Value");
        String availableTypes = this.formatAvailableUpdateCheckerTypes();
        ServerSystem.getLog().warning("Updater type '" + typeString + "' not found. Available options: " + availableTypes);
        this._updateChecker = UpdateCheckerType.DISABLED.getFactory().get();
    }

    private String formatAvailableUpdateCheckerTypes() {
        return Arrays.stream(UpdateCheckerType.values()).map(Enum::name).collect(Collectors.joining(", "));
    }

    private void initializeUpdateChecker(UpdateCheckerType type, ConfigReader generalConfig) {
        boolean autoUpdate = this.determineAutoUpdateSetting(generalConfig);
        this._updateChecker = type.getFactory().get();
        this._updateChecker.setAutoUpdate(autoUpdate);
    }

    private boolean determineAutoUpdateSetting(ConfigReader generalConfig) {
        boolean autoUpdate = generalConfig.getBoolean("UpdateChecker.AutoUpdate");
        if (Boolean.parseBoolean(System.getProperty("serversystem.disable-auto-download", "false"))) {
            autoUpdate = false;
        }
        return autoUpdate;
    }

    private void scheduleUpdateChecks(ConfigReader generalConfig) {
        boolean checkForUpdates = generalConfig.getBoolean("UpdateChecker.CheckForUpdates");
        if (!checkForUpdates) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this._plugin, this::performUpdateCheck, 20L, 72000L);
    }

    private void performUpdateCheck() {
        ((CompletableFuture)this._updateChecker.hasUpdate().exceptionally(this::handleUpdateCheckError)).thenAccept(this::handleUpdateCheckResult);
    }

    private Boolean handleUpdateCheckError(Throwable throwable) {
        ServerSystem.getLog().log(Level.WARNING, "Error checking for updates", throwable);
        return false;
    }

    private void handleUpdateCheckResult(boolean hasUpdate) {
        if (!hasUpdate) {
            return;
        }
        ((CompletableFuture)this._updateChecker.downloadUpdate().exceptionally(this::handleUpdateDownloadError)).thenAccept(this::handleUpdateDownloadResult);
    }

    private Boolean handleUpdateDownloadError(Throwable throwable) {
        ServerSystem.getLog().log(Level.WARNING, "Error downloading update", throwable);
        return false;
    }

    private void handleUpdateDownloadResult(boolean success) {
        if (success) {
            return;
        }
        ServerSystem.getLog().warning("Update-Download failed!");
    }

    public AbstractUpdateChecker getUpdateChecker() {
        return this._updateChecker;
    }
}

