/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.executables.back.CommandBack;
import me.testaccount666.serversystem.managers.config.ConfigurationManager;
import me.testaccount666.serversystem.managers.database.moderation.AbstractModerationDatabaseManager;
import me.testaccount666.serversystem.managers.database.moderation.MySqlModerationDatabaseManager;
import me.testaccount666.serversystem.managers.database.moderation.SqliteModerationDatabaseManager;
import me.testaccount666.serversystem.managers.messages.MessageManager;
import me.testaccount666.serversystem.moderation.AbstractModerationManager;
import me.testaccount666.serversystem.moderation.ban.MySqlBanManager;
import me.testaccount666.serversystem.moderation.ban.SqliteBanManager;
import me.testaccount666.serversystem.moderation.mute.MySqlMuteManager;
import me.testaccount666.serversystem.moderation.mute.SqliteMuteManager;
import me.testaccount666.serversystem.userdata.home.HomeManager;
import me.testaccount666.serversystem.userdata.money.AbstractBankAccount;
import me.testaccount666.serversystem.userdata.money.EconomyProvider;
import me.testaccount666.serversystem.userdata.persistence.EnumFieldHandler;
import me.testaccount666.serversystem.userdata.persistence.KitMapFieldHandler;
import me.testaccount666.serversystem.userdata.persistence.LocationFieldHandler;
import me.testaccount666.serversystem.userdata.persistence.PersistenceManager;
import me.testaccount666.serversystem.userdata.persistence.SaveableField;
import me.testaccount666.serversystem.userdata.persistence.UuidSetFieldHandler;
import me.testaccount666.serversystem.userdata.persistence.VanishDataFieldHandler;
import me.testaccount666.serversystem.userdata.vanish.VanishData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;

public class OfflineUser {
    protected final File userFile;
    @SaveableField(path="User.IgnoredPlayers", handler=UuidSetFieldHandler.class)
    protected final Set<UUID> ignoredPlayers = new HashSet<UUID>();
    @SaveableField(path="User.LastKnownName")
    protected String name;
    protected UUID uuid;
    protected OfflinePlayer player;
    protected AbstractModerationManager banManager;
    protected AbstractModerationManager muteManager;
    protected AbstractBankAccount bankAccount;
    protected HomeManager homeManager;
    protected FileConfiguration userConfig;
    @SaveableField(path="User.LastSeen")
    protected long lastSeen;
    @SaveableField(path="User.LastKnownIp")
    protected String lastKnownIp;
    @SaveableField(path="User.LogoutPosition", handler=LocationFieldHandler.class)
    protected Location logoutPosition;
    @SaveableField(path="User.VanishData.IsVanish")
    protected boolean isVanish;
    @SaveableField(path="User.VanishData.Data", handler=VanishDataFieldHandler.class)
    protected VanishData vanishData;
    @SaveableField(path="User.IsGodMode")
    protected boolean isGodMode;
    @SaveableField(path="User.AcceptsTeleports")
    protected boolean acceptsTeleports;
    @SaveableField(path="User.AcceptsMessages")
    protected boolean acceptsMessages;
    @SaveableField(path="User.SocialSpyEnabled")
    protected boolean socialSpyEnabled;
    @SaveableField(path="User.CommandSpyEnabled")
    protected boolean commandSpyEnabled;
    @SaveableField(path="User.LastDeathLocation", handler=LocationFieldHandler.class)
    protected Location lastDeathLocation;
    @SaveableField(path="User.LastTeleportLocation", handler=LocationFieldHandler.class)
    protected Location lastTeleportLocation;
    @SaveableField(path="User.LastBackType", handler=EnumFieldHandler.class)
    protected CommandBack.BackType lastBackType;
    @SaveableField(path="User.PlayerLanguage")
    protected String playerLanguage;
    @SaveableField(path="User.KitCooldowns", handler=KitMapFieldHandler.class)
    protected Map<String, Long> kitCooldowns = new HashMap<String, Long>();
    @SaveableField(path="Language.UsesDefault")
    protected boolean usesDefaultLanguage;

    protected OfflineUser(File userFile) {
        this.userFile = userFile;
        this.loadBasicData();
    }

    protected OfflineUser(OfflineUser onlineUser) {
        this(onlineUser.userFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCompressed(File file) {
        if (!file.exists()) return false;
        if (file.length() < 2L) {
            return false;
        }
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] signature = new byte[2];
            if (fis.read(signature) != 2) {
                boolean bl = false;
                return bl;
            }
            boolean bl = signature[0] == 31 && signature[1] == -117;
            return bl;
        }
        catch (IOException exception) {
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private FileConfiguration loadYamlConfiguration(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void loadBasicData() {
        MySqlModerationDatabaseManager database;
        SqliteModerationDatabaseManager database2;
        int n;
        AbstractModerationDatabaseManager abstractModerationDatabaseManager;
        Connection ignored;
        this.userConfig = this.loadYamlConfiguration(this.userFile);
        this.uuid = UUID.fromString(this.userFile.getName().replace(".yml.gz", ""));
        this.name = null;
        this.lastSeen = System.currentTimeMillis();
        this.lastKnownIp = "Unknown";
        this.isVanish = false;
        this.vanishData = new VanishData(false, false, false, false);
        this.isGodMode = false;
        this.acceptsTeleports = true;
        this.acceptsMessages = true;
        this.socialSpyEnabled = false;
        this.commandSpyEnabled = false;
        this.usesDefaultLanguage = true;
        this.playerLanguage = MessageManager.getDefaultLanguage();
        this.lastBackType = CommandBack.BackType.NONE;
        PersistenceManager.loadFields(this, this.userConfig);
        if (this.playerLanguage.equalsIgnoreCase(System.getProperty("user.language"))) {
            this.playerLanguage = MessageManager.getDefaultLanguage();
        }
        this.playerLanguage = this.playerLanguage.toLowerCase();
        if (this.name == null) {
            this.name = this.getPlayer().getName();
        }
        this.homeManager = new HomeManager(this, this.userConfig);
        this.bankAccount = ServerSystem.Instance.getRegistry().getService(EconomyProvider.class).instantiateBankAccount(this, BigInteger.valueOf(0L), this.userConfig);
        AbstractModerationDatabaseManager moderationManager = ServerSystem.Instance.getRegistry().getService(AbstractModerationDatabaseManager.class);
        try {
            ignored = moderationManager.getConnection();
            try {
                AbstractModerationDatabaseManager abstractModerationDatabaseManager2 = moderationManager;
                Objects.requireNonNull(abstractModerationDatabaseManager2);
                abstractModerationDatabaseManager = abstractModerationDatabaseManager2;
                n = 0;
                this.banManager = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SqliteModerationDatabaseManager.class, MySqlModerationDatabaseManager.class}, (Object)abstractModerationDatabaseManager, n)) {
                    case 0 -> {
                        database2 = (SqliteModerationDatabaseManager)abstractModerationDatabaseManager;
                        yield new SqliteBanManager(this.uuid);
                    }
                    case 1 -> {
                        database = (MySqlModerationDatabaseManager)abstractModerationDatabaseManager;
                        yield new MySqlBanManager(this.uuid);
                    }
                    default -> null;
                };
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        catch (SQLException exception) {
            throw new RuntimeException("Error loading userdata! (BanManager)", exception);
        }
        try {
            ignored = moderationManager.getConnection();
            try {
                AbstractModerationDatabaseManager abstractModerationDatabaseManager3 = moderationManager;
                Objects.requireNonNull(abstractModerationDatabaseManager3);
                abstractModerationDatabaseManager = abstractModerationDatabaseManager3;
                n = 0;
                this.muteManager = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SqliteModerationDatabaseManager.class, MySqlModerationDatabaseManager.class}, (Object)abstractModerationDatabaseManager, n)) {
                    case 0 -> {
                        database2 = (SqliteModerationDatabaseManager)abstractModerationDatabaseManager;
                        yield new SqliteMuteManager(this.uuid);
                    }
                    case 1 -> {
                        database = (MySqlModerationDatabaseManager)abstractModerationDatabaseManager;
                        yield new MySqlMuteManager(this.uuid);
                    }
                    default -> null;
                };
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        catch (SQLException exception) {
            throw new RuntimeException("Error loading userdata! (MuteManager)", exception);
        }
    }

    private boolean isCompressionEnabled() {
        return ServerSystem.Instance.getRegistry().getService(ConfigurationManager.class).getGeneralConfig().getBoolean("UserData.Compression.Enabled", true);
    }

    private void saveCompressedYamlConfiguration(FileConfiguration config, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);
             OutputStreamWriter streamWriter = new OutputStreamWriter(gzipOutputStream);){
            streamWriter.write(config.saveToString());
            streamWriter.flush();
        }
    }

    public void save() {
        PersistenceManager.saveFields(this, this.userConfig);
        try {
            if (this.isCompressionEnabled()) {
                this.saveCompressedYamlConfiguration(this.userConfig, this.userFile);
            } else {
                this.userConfig.save(this.userFile);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error while trying to save user data for user '" + String.valueOf(this.getName()) + "' ('" + String.valueOf(this.getUuid()) + "')", exception);
        }
    }

    public OfflinePlayer getPlayer() {
        if (this.player == null) {
            this.player = Bukkit.getOfflinePlayer((UUID)this.uuid);
        }
        return this.player;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Set<UUID> getIgnoredPlayers() {
        return Collections.unmodifiableSet(this.ignoredPlayers);
    }

    public boolean isIgnoredPlayer(UUID uuid) {
        return this.ignoredPlayers.contains(uuid);
    }

    public void addIgnoredPlayer(UUID uuid) {
        this.ignoredPlayers.add(uuid);
    }

    public void removeIgnoredPlayer(UUID uuid) {
        this.ignoredPlayers.remove(uuid);
    }

    public boolean isOnKitCooldown(String kitName) {
        Long cooldown = this.kitCooldowns.getOrDefault(kitName, null);
        if (cooldown == null) {
            return false;
        }
        return cooldown > System.currentTimeMillis();
    }

    public long getKitCooldown(String kitName) {
        Long cooldown = this.kitCooldowns.getOrDefault(kitName, null);
        if (cooldown == null) {
            return -1L;
        }
        return cooldown;
    }

    public void setKitCooldown(String kitName, long cooldown) {
        this.kitCooldowns.put(kitName, cooldown + System.currentTimeMillis());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public AbstractModerationManager getBanManager() {
        return this.banManager;
    }

    public AbstractModerationManager getMuteManager() {
        return this.muteManager;
    }

    public AbstractBankAccount getBankAccount() {
        return this.bankAccount;
    }

    public HomeManager getHomeManager() {
        return this.homeManager;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public String getLastKnownIp() {
        return this.lastKnownIp;
    }

    public Location getLogoutPosition() {
        return this.logoutPosition;
    }

    public void setLogoutPosition(Location logoutPosition) {
        this.logoutPosition = logoutPosition;
    }

    public boolean isVanish() {
        return this.isVanish;
    }

    public void setVanish(boolean isVanish) {
        this.isVanish = isVanish;
    }

    public VanishData getVanishData() {
        return this.vanishData;
    }

    public boolean isGodMode() {
        return this.isGodMode;
    }

    public void setGodMode(boolean isGodMode) {
        this.isGodMode = isGodMode;
    }

    public boolean isAcceptsTeleports() {
        return this.acceptsTeleports;
    }

    public void setAcceptsTeleports(boolean acceptsTeleports) {
        this.acceptsTeleports = acceptsTeleports;
    }

    public boolean isAcceptsMessages() {
        return this.acceptsMessages;
    }

    public void setAcceptsMessages(boolean acceptsMessages) {
        this.acceptsMessages = acceptsMessages;
    }

    public boolean isSocialSpyEnabled() {
        return this.socialSpyEnabled;
    }

    public void setSocialSpyEnabled(boolean socialSpyEnabled) {
        this.socialSpyEnabled = socialSpyEnabled;
    }

    public boolean isCommandSpyEnabled() {
        return this.commandSpyEnabled;
    }

    public void setCommandSpyEnabled(boolean commandSpyEnabled) {
        this.commandSpyEnabled = commandSpyEnabled;
    }

    public Location getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    public void setLastDeathLocation(Location lastDeathLocation) {
        this.lastDeathLocation = lastDeathLocation;
    }

    public Location getLastTeleportLocation() {
        return this.lastTeleportLocation;
    }

    public void setLastTeleportLocation(Location lastTeleportLocation) {
        this.lastTeleportLocation = lastTeleportLocation;
    }

    public CommandBack.BackType getLastBackType() {
        return this.lastBackType;
    }

    public void setLastBackType(CommandBack.BackType lastBackType) {
        this.lastBackType = lastBackType;
    }

    public String getPlayerLanguage() {
        return this.playerLanguage;
    }

    public void setPlayerLanguage(String playerLanguage) {
        this.playerLanguage = playerLanguage;
    }

    public boolean isUsesDefaultLanguage() {
        return this.usesDefaultLanguage;
    }

    public void setUsesDefaultLanguage(boolean usesDefaultLanguage) {
        this.usesDefaultLanguage = usesDefaultLanguage;
    }
}

