/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.NpcUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.User;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UserManager {
    public static final Path USER_DATA_PATH = Path.of("plugins", "ServerSystem", "UserData");
    private static final ConsoleUser _CONSOLE_USER = new ConsoleUser();
    private static final NpcUser _NPC_USER = new NpcUser();
    private final Map<String, CachedUser> _userMap = new ConcurrentHashMap<String, CachedUser>();
    private final Map<UUID, CachedUser> _userUuidMap = new ConcurrentHashMap<UUID, CachedUser>();

    public UserManager() {
        Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)ServerSystem.Instance, this::cleanStaleUsers, 18000L, 18000L);
        Bukkit.getOnlinePlayers().forEach(this::getUser);
    }

    private static File getUserFile(UUID uuid) {
        return USER_DATA_PATH.resolve(String.valueOf(uuid) + ".yml.gz").toFile();
    }

    public static ConsoleUser getConsoleUser() {
        return _CONSOLE_USER;
    }

    public Optional<CachedUser> getUser(Player player) {
        if (player.hasMetadata("NPC")) {
            return Optional.of(new CachedUser(_NPC_USER));
        }
        return this.getUser(player.getUniqueId(), true);
    }

    public Optional<CachedUser> getUser(UUID uuid) {
        return this.getUser(uuid, false);
    }

    public Optional<CachedUser> getUser(UUID uuid, boolean forceOnlineUser) {
        if (!forceOnlineUser && uuid.equals(ConsoleUser.CONSOLE_UUID)) {
            return Optional.of(new CachedUser(UserManager.getConsoleUser()));
        }
        if (this._userUuidMap.containsKey(uuid)) {
            CachedUser cachedUser = this._userUuidMap.get(uuid);
            if (cachedUser.isOfflineUser() && forceOnlineUser) {
                return Optional.empty();
            }
            cachedUser.updateLastAccessTime();
            return Optional.of(cachedUser);
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            return Optional.of(this.createOnlineUser(uuid));
        }
        if (forceOnlineUser) {
            return Optional.empty();
        }
        return this.createOfflineUser(uuid);
    }

    public Optional<CachedUser> getUser(String name) {
        return this.getUser(name, false);
    }

    public Optional<CachedUser> getUser(String name, boolean forceOnlineUser) {
        if (this._userMap.containsKey(name)) {
            CachedUser cachedUser = this._userMap.get(name);
            if (cachedUser.isOfflineUser() && forceOnlineUser) {
                return Optional.empty();
            }
            cachedUser.updateLastAccessTime();
            return Optional.of(cachedUser);
        }
        Player player = Bukkit.getPlayer((String)name);
        if (player != null) {
            return Optional.of(this.createOnlineUser(player.getUniqueId()));
        }
        if (forceOnlineUser) {
            return Optional.empty();
        }
        OfflinePlayer offlineUser = Bukkit.getOfflinePlayer((String)name);
        if (offlineUser.getName() == null) {
            return Optional.empty();
        }
        return this.createOfflineUser(offlineUser.getUniqueId());
    }

    private Optional<CachedUser> createOfflineUser(UUID uuid) {
        File userFile = UserManager.getUserFile(uuid);
        OfflineUser user = new OfflineUser(userFile);
        if (user.getName().isEmpty()) {
            return Optional.empty();
        }
        CachedUser cachedUser = new CachedUser(user);
        this._userUuidMap.put(uuid, cachedUser);
        this._userMap.put(user.getName().get(), cachedUser);
        return Optional.of(cachedUser);
    }

    private CachedUser createOnlineUser(UUID uuid) {
        File userFile = UserManager.getUserFile(uuid);
        User user = new User(userFile);
        CachedUser cachedUser = new CachedUser(user);
        this._userUuidMap.put(uuid, cachedUser);
        this._userMap.put(user.getName().get(), cachedUser);
        return cachedUser;
    }

    public Set<CachedUser> getCachedUsers() {
        return Set.copyOf(this._userMap.values());
    }

    public void cleanStaleUsers() {
        Set staleUsers = this._userMap.values().stream().filter(CachedUser::isStale).collect(Collectors.toSet());
        this._userMap.entrySet().removeIf(entry -> staleUsers.contains(entry.getValue()));
        this._userUuidMap.entrySet().removeIf(entry -> staleUsers.contains(entry.getValue()));
    }
}

