/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.home;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.managers.globaldata.DefaultsData;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.home.Home;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class HomeManager {
    private final OfflineUser _owner;
    private final Set<Home> _homes = new HashSet<Home>();
    private final FileConfiguration _config;

    public HomeManager(OfflineUser owner, FileConfiguration config) {
        this._owner = owner;
        this._config = config;
        this.loadHomes();
    }

    public Set<Home> getHomes() {
        return Collections.unmodifiableSet(this._homes);
    }

    public void addHome(String name, Location location) {
        this.addHome(name, location, true);
    }

    public void addHome(String name, Location location, boolean saveHomes) {
        this.addHome(new Home(name, location), saveHomes);
    }

    public void addHome(Home home) {
        this.addHome(home, true);
    }

    public void addHome(Home home, boolean saveHomes) {
        this._homes.add(home);
        if (saveHomes) {
            this.saveHomes();
        }
    }

    public void removeHome(String name) {
        this._homes.removeIf(home -> home.getName().equalsIgnoreCase(name));
        this.saveHomes();
    }

    public void removeHome(Home home) {
        this._homes.removeIf(savedHome -> savedHome.getName().equalsIgnoreCase(home.getName()));
        this.saveHomes();
    }

    public Optional<Home> getHomeByName(String name) {
        return this._homes.stream().filter(home -> home.getName().equalsIgnoreCase(name)).findFirst();
    }

    public boolean hasHome(String name) {
        return this.getHomeByName(name).isPresent();
    }

    public Optional<Integer> getMaxHomeCount() {
        OfflineUser offlineUser = this._owner;
        if (!(offlineUser instanceof User)) {
            return Optional.empty();
        }
        User user = (User)offlineUser;
        if (PermissionManager.hasPermission((CommandSender)user.getPlayer(), "Homes.Unlimited", false)) {
            return Optional.of(Integer.MAX_VALUE);
        }
        int defaultValue = DefaultsData.home().getDefaultMaxHomes();
        int maxHomes = -1;
        Object permissionPattern = PermissionManager.getPermission("Homes.MaxHomes");
        if (!((String)permissionPattern).endsWith(".")) {
            permissionPattern = (String)permissionPattern + ".";
        }
        for (PermissionAttachmentInfo effectivePermission : user.getPlayer().getEffectivePermissions()) {
            String permission = effectivePermission.getPermission();
            if (!permission.toLowerCase().startsWith(((String)permissionPattern).toLowerCase())) continue;
            try {
                int parsed = Integer.parseInt(permission.substring(((String)permissionPattern).length()));
                if (parsed <= maxHomes) continue;
                maxHomes = parsed;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (maxHomes == -1) {
            maxHomes = defaultValue;
        }
        return Optional.of(maxHomes);
    }

    private void saveHomes() {
        this._config.set("User.Homes", null);
        for (Home home : this._homes) {
            String prefix = "User.Homes." + home.getName();
            this._config.set(prefix + ".X", (Object)home.getLocation().getX());
            this._config.set(prefix + ".Y", (Object)home.getLocation().getY());
            this._config.set(prefix + ".Z", (Object)home.getLocation().getZ());
            this._config.set(prefix + ".Yaw", (Object)Float.valueOf(home.getLocation().getYaw()));
            this._config.set(prefix + ".Pitch", (Object)Float.valueOf(home.getLocation().getPitch()));
            this._config.set(prefix + ".World", (Object)home.getLocation().getWorld().getName());
        }
        this._owner.save();
    }

    private void loadHomes() {
        this._homes.clear();
        if (!this._config.isConfigurationSection("User.Homes")) {
            return;
        }
        Set homeNames = this._config.getConfigurationSection("User.Homes").getKeys(false);
        for (String name : homeNames) {
            String prefix;
            Optional<Home> home = this.parseHome(name, prefix = "User.Homes." + name);
            if (home.isEmpty()) continue;
            this._homes.add(home.get());
        }
    }

    private Optional<Home> parseHome(String name, String prefix) {
        double x = this._config.getDouble(prefix + ".X");
        double y = this._config.getDouble(prefix + ".Y");
        double z = this._config.getDouble(prefix + ".Z");
        float yaw = (float)this._config.getDouble(prefix + ".Yaw");
        float pitch = (float)this._config.getDouble(prefix + ".Pitch");
        String worldName = this._config.getString(prefix + ".World", "");
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            return Optional.empty();
        }
        Location location = new Location(world, x, y, z, yaw, pitch);
        return Optional.of(new Home(name, location));
    }
}

