/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.userdata.money;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.database.economy.AbstractEconomyDatabaseManager;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.money.AbstractBankAccount;
import me.testaccount666.serversystem.userdata.money.AbstractSqlBankAccount;
import me.testaccount666.serversystem.userdata.money.DisabledBankAccount;
import me.testaccount666.serversystem.userdata.money.MySqlBankAccount;
import me.testaccount666.serversystem.userdata.money.SqliteBankAccount;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class EconomyProvider {
    private final String _currencySingular;
    private final String _currencyPlural;
    private final String _thousandSeparator;
    private final String _decimalSeparator;
    private final String _moneyFormat;
    private final String _defaultBalance;
    private final Type _economyType;

    public EconomyProvider(ConfigReader configReader) {
        this._currencySingular = configReader.getString("Economy.Format.CurrencySymbol.Singular");
        this._currencyPlural = configReader.getString("Economy.Format.CurrencySymbol.Plural");
        this._thousandSeparator = configReader.getString("Economy.Format.Separators.Thousands");
        this._decimalSeparator = configReader.getString("Economy.Format.Separators.Decimals");
        this._moneyFormat = configReader.getString("Economy.Format.MoneyFormat");
        this._defaultBalance = configReader.getString("Economy.StartingBalance");
        if (!configReader.getBoolean("Economy.Enabled", true)) {
            this._economyType = Type.DISABLED;
            return;
        }
        Optional<Type> economyTypeOptional = Type.parseType(configReader.getString("Economy.StorageType.Value").toUpperCase());
        AbstractEconomyDatabaseManager databaseManager = ServerSystem.Instance.getRegistry().getService(AbstractEconomyDatabaseManager.class);
        if (economyTypeOptional.isEmpty()) {
            this._economyType = Type.SQLITE;
            ServerSystem.getLog().warning("Found invalid economy type in the 'economy.yml'! Using SQLITE as default!");
            return;
        }
        this._economyType = economyTypeOptional.get();
        databaseManager.initialize();
    }

    public AbstractBankAccount instantiateBankAccount(OfflineUser offlineUser, BigInteger accountId, FileConfiguration userConfig) {
        if (this._economyType == Type.DISABLED) {
            return new DisabledBankAccount(offlineUser.getUuid(), accountId);
        }
        this.migrateYamlBankAccountIfNeeded(offlineUser, accountId, userConfig);
        return switch (this._economyType.ordinal()) {
            case 0 -> new MySqlBankAccount(offlineUser.getUuid(), accountId);
            case 1 -> new SqliteBankAccount(offlineUser.getUuid(), accountId);
            default -> {
                ServerSystem.getLog().warning("Found invalid economy type '" + String.valueOf((Object)this._economyType) + "' in the 'economy.yml'! Using Sqlite as default!");
                yield new SqliteBankAccount(offlineUser.getUuid(), accountId);
            }
        };
    }

    private void migrateYamlBankAccountIfNeeded(OfflineUser offlineUser, BigInteger accountId, FileConfiguration userConfig) {
        if (!userConfig.isSet("User.BankAccounts")) {
            return;
        }
        ConfigurationSection bankAccountsSection = userConfig.getConfigurationSection("User.BankAccounts");
        if (bankAccountsSection == null) {
            ServerSystem.getLog().severe("Failed to get YAML bank accounts for user " + String.valueOf(offlineUser.getName()) + " (" + String.valueOf(offlineUser.getUuid()) + "): bankAccountsSection is null!");
            return;
        }
        boolean anyMigrated = false;
        for (String key : bankAccountsSection.getKeys(false)) {
            String balance = bankAccountsSection.getString(key + ".Balance");
            if (balance == null) {
                ServerSystem.getLog().severe("Failed to get YAML bank account balance for user " + String.valueOf(offlineUser.getName()) + " (" + String.valueOf(offlineUser.getUuid()) + ", AccountID: " + key + "): balance is null!");
                continue;
            }
            try {
                BigInteger currentAccountId = new BigInteger(key);
                AbstractSqlBankAccount bankAccount = switch (this._economyType.ordinal()) {
                    case 0 -> new MySqlBankAccount(offlineUser.getUuid(), currentAccountId);
                    case 1 -> new SqliteBankAccount(offlineUser.getUuid(), currentAccountId);
                    default -> throw new IllegalStateException("Unexpected economy type: " + String.valueOf((Object)this._economyType) + " - Supported values: mysql, sqlite");
                };
                bankAccount.setBalance(new BigDecimal(balance));
                if (currentAccountId.equals(accountId)) {
                    anyMigrated = true;
                }
                ServerSystem.getLog().info("Migrated YAML bank account data for user " + String.valueOf(offlineUser.getName()) + " (" + String.valueOf(offlineUser.getUuid()) + ", AccountID: " + String.valueOf(currentAccountId) + ") to " + String.valueOf((Object)this._economyType) + " database. Balance: " + balance);
            }
            catch (NumberFormatException exception) {
                ServerSystem.getLog().log(Level.SEVERE, "Failed to migrate YAML bank account data for user " + String.valueOf(offlineUser.getName()) + " (" + String.valueOf(offlineUser.getUuid()) + ", AccountID: " + key + "): " + exception.getMessage(), exception);
            }
        }
        if (!anyMigrated) {
            return;
        }
        userConfig.set("User.BankAccounts", null);
        offlineUser.save();
        ServerSystem.getLog().info("Completed migration of all YAML bank accounts for user " + String.valueOf(offlineUser.getName()) + " (" + String.valueOf(offlineUser.getUuid()) + ")");
    }

    public String formatMoney(BigDecimal balance) {
        Object balanceString = balance.toPlainString();
        if (!((String)balanceString).contains(".")) {
            balanceString = (String)balanceString + ".00";
        }
        String major = ((String)balanceString).split("\\.")[0];
        Object decimal = ((String)balanceString).split("\\.")[1];
        major = major.replaceAll("(\\d)(?=(\\d\\d\\d)+(?!\\d))", "$1" + this._thousandSeparator);
        if (((String)decimal).length() > 2) {
            decimal = ((String)decimal).substring(0, 2);
        }
        if (((String)decimal).length() == 1) {
            decimal = (String)decimal + "0";
        }
        if (((String)decimal).isEmpty()) {
            decimal = "00";
        }
        String currencySymbol = balance.compareTo(BigDecimal.ZERO) > 0 ? this._currencySingular : this._currencyPlural;
        return this._moneyFormat.replace("<MAJOR>", major).replace("<DECIMAL>", (CharSequence)decimal).replace("<DECIMAL_SEPARATOR>", this._decimalSeparator).replace("<CURRENCY>", currencySymbol);
    }

    public String getCurrencySingular() {
        return this._currencySingular;
    }

    public String getCurrencyPlural() {
        return this._currencyPlural;
    }

    public String getDefaultBalance() {
        return this._defaultBalance;
    }

    public Type getEconomyType() {
        return this._economyType;
    }

    public static enum Type {
        MYSQL,
        SQLITE,
        DISABLED;


        public static Optional<Type> parseType(String value) {
            if (value == null) {
                return Optional.empty();
            }
            try {
                return Optional.of(Type.valueOf(value.toUpperCase()));
            }
            catch (IllegalArgumentException ignored) {
                return Optional.empty();
            }
        }
    }
}

