/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.text.SimpleDateFormat;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.messages.MappingsData;
import me.testaccount666.serversystem.userdata.OfflineUser;

public class DurationParser {
    private static final long _SECONDS_IN_MINUTE = 60L;
    private static final long _SECONDS_IN_HOUR = 3600L;
    private static final long _SECONDS_IN_DAY = 86400L;
    private static final long _SECONDS_IN_WEEK = 604800L;
    private static final long _SECONDS_IN_MONTH = 2419200L;
    private static final long _SECONDS_IN_YEAR = 31536000L;

    public static String parseDate(long durationMillis, OfflineUser user) {
        if (durationMillis == -1L) {
            Optional<String> permanentOptional = MappingsData.moderation(user).getName("permanent");
            if (permanentOptional.isEmpty()) {
                ServerSystem.getLog().warning("Permanent name could not be found! This should not happen!");
                return "Never";
            }
            return permanentOptional.get();
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        return dateFormatter.format(durationMillis);
    }

    public static long parseDuration(String duration) {
        if (duration.equalsIgnoreCase("permanent")) {
            return -1L;
        }
        Pattern regex = Pattern.compile("(\\d{1,9})(mo|y|w|d|h|m|s)");
        Matcher matcher = regex.matcher(duration);
        long totalSeconds = 0L;
        try {
            while (matcher.find()) {
                String unit;
                long value = Long.parseLong(matcher.group(1));
                value = Math.max(0L, value);
                switch (unit = matcher.group(2)) {
                    case "y": {
                        totalSeconds += value * 31536000L;
                        break;
                    }
                    case "mo": {
                        totalSeconds += value * 2419200L;
                        break;
                    }
                    case "w": {
                        totalSeconds += value * 604800L;
                        break;
                    }
                    case "d": {
                        totalSeconds += value * 86400L;
                        break;
                    }
                    case "h": {
                        totalSeconds += value * 3600L;
                        break;
                    }
                    case "m": {
                        totalSeconds += value * 60L;
                        break;
                    }
                    case "s": {
                        totalSeconds += value;
                    }
                }
            }
        }
        catch (NumberFormatException ignored) {
            return -2L;
        }
        return totalSeconds *= 1000L;
    }
}

