/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.lang.reflect.Field;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class FieldAccessor {
    private FieldAccessor() {
    }

    public static <T, R> Function<T, R> createGetter(Class<T> targetClass, String fieldName) {
        try {
            Field field = FieldAccessor.findField(targetClass, fieldName);
            field.setAccessible(true);
            return instance -> {
                try {
                    Object value = field.get(instance);
                    return value;
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException("Failed to get field value for " + targetClass.getName() + "." + fieldName, exception);
                }
            };
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException("Failed to create field accessor for " + targetClass.getName() + "." + fieldName, exception);
        }
    }

    private static Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException exception) {
                continue;
            }
        }
        throw new NoSuchFieldException("Field '" + fieldName + "' not found in class " + clazz.getName() + " or any of its superclasses");
    }

    public static <T, R> Function<T, R> createGetter(Class<T> targetClass, String fieldName, Class<R> fieldType) {
        try {
            Field field = FieldAccessor.findField(targetClass, fieldName);
            field.setAccessible(true);
            if (!fieldType.isAssignableFrom(field.getType())) {
                throw new IllegalArgumentException("Field '" + fieldName + "' of type " + field.getType().getName() + " is not assignable to provided type " + fieldType.getName());
            }
            return instance -> {
                try {
                    Object value = field.get(instance);
                    return value;
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException("Failed to get field value for " + targetClass.getName() + "." + fieldName, exception);
                }
            };
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException("Failed to create field accessor for " + targetClass.getName() + "." + fieldName, exception);
        }
    }

    public static <T, R> BiFunction<T, R, R> createSetter(Class<T> targetClass, String fieldName) {
        try {
            Field field = FieldAccessor.findField(targetClass, fieldName);
            field.setAccessible(true);
            return (instance, value) -> {
                try {
                    field.set(instance, value);
                    return value;
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException("Failed to set field value for " + targetClass.getName() + "." + fieldName, exception);
                }
            };
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException("Failed to create field accessor for " + targetClass.getName() + "." + fieldName, exception);
        }
    }

    public static <T, R> BiFunction<T, R, R> createSetter(Class<T> targetClass, String fieldName, Class<R> fieldType) {
        try {
            Field field = FieldAccessor.findField(targetClass, fieldName);
            field.setAccessible(true);
            if (!fieldType.isAssignableFrom(field.getType())) {
                throw new IllegalArgumentException("Field '" + fieldName + "' of type " + field.getType().getName() + " is not assignable to provided type " + fieldType.getName());
            }
            return (instance, value) -> {
                try {
                    field.set(instance, value);
                    return value;
                }
                catch (IllegalAccessException exception) {
                    throw new RuntimeException("Failed to set field value for " + targetClass.getName() + "." + fieldName, exception);
                }
            };
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException("Failed to create field accessor for " + targetClass.getName() + "." + fieldName, exception);
        }
    }
}

