/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import me.testaccount666.serversystem.exceptions.NotDirectoryException;

public final class FileUtils {
    public static void deleteDirectory(File file) throws IOException {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            FileUtils.deleteFile(file);
            return;
        }
        for (File listedFile : file.listFiles()) {
            if (listedFile.isDirectory()) {
                FileUtils.deleteDirectory(listedFile);
                continue;
            }
            FileUtils.deleteFile(listedFile);
        }
        FileUtils.deleteFile(file);
    }

    public static void deleteFile(File file) throws IOException {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        if (!file.delete()) {
            throw new IOException("Couldn't delete file: " + file.getAbsolutePath());
        }
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        if (source == null) {
            return;
        }
        if (destination == null) {
            return;
        }
        if (!source.exists()) {
            throw new FileNotFoundException("File not found: " + String.valueOf(source));
        }
        if (!source.isDirectory()) {
            FileUtils.copyFile(source, destination);
            return;
        }
        if (source.getCanonicalPath().equals(destination.getCanonicalPath())) {
            throw new IOException("Destination and source are the same!");
        }
        if (!destination.exists()) {
            if (!destination.mkdirs()) {
                throw new IOException("Could not copy file: " + source.getAbsolutePath() + "\nTo: " + destination.getAbsolutePath());
            }
            if (!destination.isDirectory()) {
                throw new NotDirectoryException("Destination is not a directory!");
            }
        }
        for (File file : source.listFiles()) {
            if (file.isDirectory()) {
                FileUtils.copyDirectory(file, new File(destination, file.getName()));
                continue;
            }
            FileUtils.copyFile(file, new File(destination, file.getName()));
        }
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (source == null) {
            return;
        }
        if (destination == null) {
            return;
        }
        if (!source.exists()) {
            throw new FileNotFoundException("File not found: " + String.valueOf(source));
        }
        if (source.getCanonicalPath().equals(destination.getCanonicalPath())) {
            throw new IOException("Destination and source are the same!");
        }
        InputStream inputStream = Files.newInputStream(source.toPath(), new OpenOption[0]);
        OutputStream outputStream = Files.newOutputStream(destination.toPath(), new OpenOption[0]);
        int data = inputStream.read();
        while (data != -1) {
            outputStream.write(data);
            data = inputStream.read();
        }
        outputStream.flush();
        outputStream.close();
        inputStream.close();
    }
}

