/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.back;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.managers.messages.MappingsData;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="back")
public class CommandBack
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Back.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        BackType backType = commandSender.getLastBackType();
        BackType backType2 = backType = backType == BackType.NONE ? BackType.DEATH : backType;
        if (arguments.length > 0) {
            switch (arguments[0].toLowerCase()) {
                case "death": {
                    BackType backType3 = BackType.DEATH;
                    break;
                }
                case "teleport": 
                case "tp": {
                    BackType backType3 = BackType.TELEPORT;
                    break;
                }
                default: {
                    MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
                    BackType backType3 = backType = null;
                }
            }
        }
        if (backType == null) {
            return;
        }
        Location backLocation = switch (backType.ordinal()) {
            case 0 -> commandSender.getLastDeathLocation();
            case 1 -> commandSender.getLastTeleportLocation();
            default -> {
                MessageBuilder.general("ErrorOccurred", commandSender).label(label).build();
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)backType));
            }
        };
        if (backLocation == null) {
            MessageBuilder.command("Back.NoBackLocation", commandSender).build();
            return;
        }
        commandSender.getPlayer().teleport(backLocation);
        BackType finalBackType = backType;
        Optional<String> typeNameOptional = MappingsData.backType(commandSender).getBackTypeName(finalBackType);
        String typeName = typeNameOptional.orElse("ERROR");
        MessageBuilder.command("Back.Success", commandSender).postModifier(message -> message.replace("<TYPE>", typeName)).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Back";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Back.Use", false);
    }

    public static enum BackType {
        DEATH,
        TELEPORT,
        NONE;

    }
}

