/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.commandspy;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="commandspy")
public class CommandCommandSpy
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "CommandSpy.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "CommandSpy.Other", targetPlayer.getName())) {
            return;
        }
        boolean isEnabled = !targetUser.isCommandSpyEnabled();
        Object messagePath = isSelf ? "CommandSpy.Success" : "CommandSpy.SuccessOther";
        messagePath = (String)messagePath + (isEnabled ? ".Enabled" : ".Disabled");
        targetUser.setCommandSpyEnabled(isEnabled);
        targetUser.save();
        MessageBuilder.command((String)messagePath, commandSender).target(targetPlayer.getName()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("CommandSpy.Success" + (isEnabled ? "Enabled" : "Disabled"), targetUser).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "CommandSpy";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "CommandSpy.Use", false);
    }
}

