/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.economy;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.UnaryOperator;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.economy.TabCompleterEconomy;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="economy", tabCompleter=TabCompleterEconomy.class)
public class CommandEconomy
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        String economyOperation;
        BigDecimal amount;
        if (!this.checkBasePermission(commandSender, "Economy.Use")) {
            return;
        }
        if (arguments.length <= 2) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, 1, false, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[1]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        try {
            amount = new BigDecimal(arguments[2]);
        }
        catch (NumberFormatException ignored) {
            MessageBuilder.command("Economy.InvalidAmount", commandSender).build();
            return;
        }
        switch (economyOperation = arguments[0].toLowerCase()) {
            case "set": {
                this.handleSetEconomy(commandSender, label, targetUser, amount);
                break;
            }
            case "give": 
            case "add": {
                this.handleGiveEconomy(commandSender, label, targetUser, amount);
                break;
            }
            case "take": 
            case "remove": {
                this.handleTakeEconomy(commandSender, label, targetUser, amount);
                break;
            }
            default: {
                MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(command)).label(label).build();
            }
        }
    }

    private void handleSetEconomy(User commandSender, String label, User targetUser, BigDecimal amount) {
        if (!this.checkBasePermission(commandSender, "Economy.Set")) {
            return;
        }
        targetUser.getBankAccount().setBalance(amount);
        this.sendSuccess(commandSender, label, targetUser, amount, "Set");
    }

    private void handleGiveEconomy(User commandSender, String label, User targetUser, BigDecimal amount) {
        if (!this.checkBasePermission(commandSender, "Economy.Give")) {
            return;
        }
        targetUser.getBankAccount().deposit(amount);
        this.sendSuccess(commandSender, label, targetUser, amount, "Give");
    }

    private void handleTakeEconomy(User commandSender, String label, User targetUser, BigDecimal amount) {
        if (!this.checkBasePermission(commandSender, "Economy.Take")) {
            return;
        }
        targetUser.getBankAccount().withdraw(amount);
        this.sendSuccess(commandSender, label, targetUser, amount, "Take");
    }

    public void sendSuccess(User commandSender, String label, User targetUser, BigDecimal amount, String key) {
        String formattedAmount = ServerSystem.Instance.getEconomyProvider().formatMoney(amount);
        UnaryOperator modifier = message -> message.replace("<AMOUNT>", formattedAmount);
        MessageBuilder.command("Economy." + key + ".Success", commandSender).target(targetUser.getName().get()).postModifier(modifier).build();
        MessageBuilder.command("Economy." + key + ".SuccessOther", targetUser).sender(commandSender.getName().get()).target(targetUser.getName().get()).postModifier(modifier).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Economy";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Economy.Use", false);
    }
}

