/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.fly;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="fly")
public class CommandFly
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "Fly.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "Fly.Other", targetPlayer.getName())) {
            return;
        }
        boolean isFlying = !targetPlayer.getAllowFlight();
        Object messagePath = isSelf ? "Fly.Success" : "Fly.SuccessOther";
        messagePath = isFlying ? (String)messagePath + ".Enabled" : (String)messagePath + ".Disabled";
        boolean isOnGround = targetPlayer.getLocation().add(0.0, -0.3, 0.0).getBlock().getType().isSolid();
        targetPlayer.setAllowFlight(isFlying);
        if (!isOnGround) {
            targetPlayer.setFlying(isFlying);
        }
        MessageBuilder.command((String)messagePath, commandSender).target(targetPlayer.getName()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("Fly.Success." + (isFlying ? "Enabled" : "Disabled"), targetUser).sender(commandSender.getName().get()).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Fly";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Fly.Use", false);
    }
}

