/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.gamemode;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemTabCompleter;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.managers.messages.MappingsData;
import me.testaccount666.serversystem.userdata.User;
import org.bukkit.command.Command;

public class TabCompleterGameMode
implements ServerSystemTabCompleter {
    @Override
    public Optional<List<String>> tabComplete(User commandSender, Command command, String label, String ... arguments) {
        if (!PermissionManager.hasCommandPermission(commandSender, "GameMode.Use", false)) {
            return Optional.empty();
        }
        if (command.getName().equalsIgnoreCase("gamemode")) {
            return this.handleGameModeCommand(arguments);
        }
        return arguments.length == 1 ? Optional.empty() : Optional.of(List.of());
    }

    private Optional<List<String>> handleGameModeCommand(String[] arguments) {
        if (arguments.length == 1) {
            ArrayList<String> possibleCompletions = new ArrayList<String>(List.of("0", "1", "2", "3"));
            possibleCompletions.addAll(MappingsData.gameMode().getGameModeNames());
            ArrayList<String> completions = new ArrayList<String>();
            for (String possibleCompletion : possibleCompletions) {
                if (!possibleCompletion.toLowerCase().startsWith(arguments[0].toLowerCase())) continue;
                completions.add(possibleCompletion);
            }
            return Optional.of(completions);
        }
        if (arguments.length == 2) {
            return Optional.empty();
        }
        return Optional.of(List.of());
    }
}

