/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.heal;

import java.util.Optional;
import java.util.Set;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

@ServerSystemCommand(name="heal", variants={"feed"})
public class CommandHeal
extends AbstractServerSystemCommand {
    private final Set<PotionEffectType> _badEffectsSet = Set.of(PotionEffectType.INSTANT_DAMAGE, PotionEffectType.INFESTED, PotionEffectType.SLOWNESS, PotionEffectType.BAD_OMEN, PotionEffectType.DARKNESS, PotionEffectType.GLOWING, PotionEffectType.UNLUCK, PotionEffectType.BLINDNESS, PotionEffectType.HUNGER, PotionEffectType.MINING_FATIGUE, PotionEffectType.NAUSEA, PotionEffectType.OOZING, PotionEffectType.POISON, PotionEffectType.WITHER, PotionEffectType.WEAKNESS, PotionEffectType.LEVITATION);

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (command.getName().equalsIgnoreCase("heal")) {
            this.handleHealCommand(commandSender, command, label, arguments);
            return;
        }
        this.handleFeedCommand(commandSender, command, label, arguments);
    }

    private void handleFeedCommand(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "Feed.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "Feed.Other", targetPlayer.getName())) {
            return;
        }
        targetPlayer.setFoodLevel(20);
        targetPlayer.setSaturation(20.0f);
        String messagePath = isSelf ? "Feed.Success" : "Feed.SuccessOther";
        MessageBuilder.command(messagePath, commandSender).target(targetPlayer.getName()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("Feed.Success", targetUser).sender(commandSender.getName().get()).target(targetPlayer.getName()).build();
    }

    private void handleHealCommand(User commandSender, Command command, String label, String ... arguments) {
        boolean isSelf;
        if (!this.checkBasePermission(commandSender, "Heal.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetUserOptional = this.getTargetUser(commandSender, arguments);
        if (targetUserOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetUserOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean bl = isSelf = targetUser == commandSender;
        if (!isSelf && !this.checkOtherPermission(commandSender, "Heal.Other", targetPlayer.getName())) {
            return;
        }
        targetPlayer.setHealth(targetPlayer.getAttribute(Attribute.MAX_HEALTH).getValue());
        targetPlayer.setFoodLevel(20);
        targetPlayer.setSaturation(20.0f);
        targetPlayer.setFireTicks(0);
        this._badEffectsSet.forEach(arg_0 -> ((Player)targetPlayer).removePotionEffect(arg_0));
        String messagePath = isSelf ? "Heal.Success" : "Heal.SuccessOther";
        MessageBuilder.command(messagePath, commandSender).target(targetPlayer.getName()).build();
        if (isSelf) {
            return;
        }
        MessageBuilder.command("Heal.Success", targetUser).sender(commandSender.getName().get()).target(targetPlayer.getName()).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        String commandName;
        return switch (commandName = command.getName().toLowerCase()) {
            case "heal" -> "Heal";
            case "feed" -> "Feed";
            default -> throw new IllegalStateException("(CommandHeal) Unexpected value: " + commandName);
        };
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Heal.Use", false);
    }
}

