/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.home.user;

import java.util.List;
import java.util.Optional;
import me.testaccount666.serversystem.commands.executables.home.admin.TabCompleterAdminHome;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemTabCompleter;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.userdata.home.Home;
import me.testaccount666.serversystem.userdata.home.HomeManager;
import org.bukkit.command.Command;

public class TabCompleterHome
implements ServerSystemTabCompleter {
    private final TabCompleterAdminHome _tabCompleterAdminHome = new TabCompleterAdminHome();

    @Override
    public Optional<List<String>> tabComplete(User commandSender, Command command, String label, String ... arguments) {
        if (command.getName().toLowerCase().startsWith("admin")) {
            return this._tabCompleterAdminHome.tabComplete(commandSender, command, label, arguments);
        }
        if (command.getName().equalsIgnoreCase("sethome")) {
            return this.handleSetHomeCommand();
        }
        if (command.getName().equalsIgnoreCase("deletehome")) {
            return this.handleDeleteHomeCommand(commandSender, label, arguments);
        }
        return this.handleHomeCommand(commandSender, label, arguments);
    }

    private Optional<List<String>> handleHomeCommand(User commandSender, String label, String ... arguments) {
        if (!PermissionManager.hasCommandPermission(commandSender, "Home.Use", false)) {
            return Optional.empty();
        }
        return this.handleHomeCompletion(commandSender, arguments);
    }

    private Optional<List<String>> handleSetHomeCommand() {
        return Optional.of(List.of());
    }

    private Optional<List<String>> handleDeleteHomeCommand(User commandSender, String label, String ... arguments) {
        if (!PermissionManager.hasCommandPermission(commandSender, "DeleteHome.Use", false)) {
            return Optional.empty();
        }
        return this.handleHomeCompletion(commandSender, arguments);
    }

    private Optional<List<String>> handleHomeCompletion(User commandSender, String ... arguments) {
        if (arguments.length != 1) {
            return Optional.of(List.of());
        }
        HomeManager homeManager = commandSender.getHomeManager();
        List<String> potentialCompletions = homeManager.getHomes().stream().map(Home::getDisplayName).toList();
        List<String> completions = potentialCompletions.stream().filter(completion -> completion.toLowerCase().startsWith(arguments[0].toLowerCase())).toList();
        return Optional.of(completions);
    }
}

