/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.inventorysee.offline;

import de.tr7zw.nbtapi.NBT;
import java.util.Optional;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.inventorysee.offline.InventoryLoader;
import me.testaccount666.serversystem.commands.executables.inventorysee.online.CommandInventorySee;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class CommandOfflineInventorySee
extends AbstractServerSystemCommand {
    public final InventoryLoader inventoryLoader;

    public CommandOfflineInventorySee(CommandInventorySee commandInventorySee) {
        if (!Bukkit.getPluginManager().isPluginEnabled("NBTAPI")) {
            ServerSystem.getLog().warning("NBTAPI is not installed, Offline-InventorySee will not work!");
            this.inventoryLoader = null;
            return;
        }
        if (!NBT.preloadApi()) {
            ServerSystem.getLog().severe("Failed to load NBT-API!");
            this.inventoryLoader = null;
            return;
        }
        this.inventoryLoader = new InventoryLoader();
    }

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (this.inventoryLoader == null) {
            MessageBuilder.general("CommandDisabled", commandSender).label(label).postModifier(message -> message.replace("<REASON>", "NBTAPI is not installed, Offline-InventorySee will not work!"));
            return;
        }
        if (!command.getName().equalsIgnoreCase("offlineinventorysee")) {
            return;
        }
        this.processOfflineInventorySee(commandSender, label, arguments);
    }

    public void processOfflineInventorySee(User commandSender, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "OfflineInventorySee.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (arguments.length < 1) {
            MessageBuilder.general("InvalidArguments", commandSender).syntaxPath(this.getSyntaxPath(null)).label(label).build();
            return;
        }
        Optional<CachedUser> cachedUserOptional = ServerSystem.Instance.getUserManager().getUser(arguments[0]);
        if (cachedUserOptional.isEmpty()) {
            MessageBuilder.general("Offline.NeverPlayed", commandSender).target(arguments[0]).build();
            return;
        }
        CachedUser cachedUser = cachedUserOptional.get();
        if (cachedUser.isOnlineUser()) {
            MessageBuilder.general("Offline.NotOffline", commandSender).target(arguments[0]).build();
            return;
        }
        OfflineUser targetUser = cachedUser.getOfflineUser();
        OfflinePlayer targetPlayer = targetUser.getPlayer();
        Optional<Inventory> inventoryOptional = this.inventoryLoader.loadOfflineInventory(targetPlayer);
        if (inventoryOptional.isEmpty()) {
            MessageBuilder.general("ErrorOccurred", commandSender).label(label).target(arguments[0]).build();
            return;
        }
        Inventory inventory = inventoryOptional.get();
        commandSender.getPlayer().openInventory(inventory);
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "OfflineInventorySee";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "OfflineInventorySee.Use", false);
    }
}

