/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.kit.manager;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class Kit {
    private final String _name;
    private final long _coolDown;
    private final ItemStack _offHandItem;
    private final ItemStack[] _armorContents;
    private final ItemStack[] _inventoryContents;
    private String _displayName = null;

    public String getDisplayName() {
        if (this._displayName != null) {
            return this._displayName;
        }
        this._displayName = this._name;
        char[] charArray = this._name.toCharArray();
        charArray[0] = Character.toUpperCase(charArray[0]);
        this._displayName = new String(charArray);
        return this._displayName;
    }

    public void giveKit(Player player) {
        PlayerInventory inventory = player.getInventory();
        ArrayList<ItemStack> overflowItems = new ArrayList<ItemStack>();
        this.handleOffHandItem(inventory, overflowItems);
        this.handleArmorItems(inventory, overflowItems);
        this.handleInventoryItems((Inventory)inventory, overflowItems);
        this.dropOverflowItems((Entity)player, overflowItems);
    }

    private void handleOffHandItem(PlayerInventory inventory, List<ItemStack> overflowItems) {
        if (this._offHandItem == null) {
            return;
        }
        ItemStack currentOffHandItem = inventory.getItemInOffHand();
        if (!currentOffHandItem.getType().isAir()) {
            overflowItems.add(this._offHandItem);
            return;
        }
        inventory.setItemInOffHand(this._offHandItem);
    }

    private void handleArmorItems(PlayerInventory inventory, List<ItemStack> overflowItems) {
        if (this._armorContents == null) {
            return;
        }
        EquipmentSlot[] slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        for (int index = 0; index < this._armorContents.length; ++index) {
            ItemStack currentItem = inventory.getItem(slots[index]);
            ItemStack newArmorItem = this._armorContents[index];
            if (newArmorItem == null) continue;
            if (!currentItem.getType().isAir()) {
                overflowItems.add(newArmorItem);
                continue;
            }
            inventory.setItem(slots[index], newArmorItem);
        }
    }

    private void handleInventoryItems(Inventory inventory, List<ItemStack> overflowItems) {
        if (this._inventoryContents == null) {
            return;
        }
        for (int index = 0; index < this._inventoryContents.length; ++index) {
            ItemStack currentItem = inventory.getItem(index);
            ItemStack newInventoryItem = this._inventoryContents[index];
            if (newInventoryItem == null) continue;
            if (currentItem != null && !currentItem.getType().isAir()) {
                overflowItems.add(newInventoryItem);
                continue;
            }
            inventory.setItem(index, newInventoryItem);
        }
    }

    private void dropOverflowItems(Entity player, List<ItemStack> overflowItems) {
        if (overflowItems.isEmpty()) {
            return;
        }
        for (ItemStack item : overflowItems) {
            player.getWorld().dropItem(player.getLocation(), item, entity -> entity.setOwner(player.getUniqueId()));
        }
    }

    public String getName() {
        return this._name;
    }

    public long getCoolDown() {
        return this._coolDown;
    }

    public ItemStack getOffHandItem() {
        return this._offHandItem;
    }

    public ItemStack[] getArmorContents() {
        return this._armorContents;
    }

    public ItemStack[] getInventoryContents() {
        return this._inventoryContents;
    }

    public Kit(String name, long coolDown, ItemStack offHandItem, ItemStack[] armorContents, ItemStack[] inventoryContents) {
        this._name = name;
        this._coolDown = coolDown;
        this._offHandItem = offHandItem;
        this._armorContents = armorContents;
        this._inventoryContents = inventoryContents;
    }
}

