/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.kit.manager;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.executables.kit.manager.Kit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class KitManager {
    private final Map<String, Kit> _kits = new HashMap<String, Kit>();

    public KitManager() {
        File kitDirectory = Path.of(ServerSystem.Instance.getDataFolder().getPath(), "Kits").toFile();
        if (!kitDirectory.exists()) {
            kitDirectory.mkdirs();
        } else if (!kitDirectory.isDirectory()) {
            throw new IllegalStateException("The Kit directory is not a directory!");
        }
        File[] kitFiles = kitDirectory.listFiles();
        if (kitFiles == null) {
            return;
        }
        for (File kitFile : kitFiles) {
            ConfigurationSection inventorySection;
            YamlConfiguration kitConfig = YamlConfiguration.loadConfiguration((File)kitFile);
            String name = kitConfig.getString("Name");
            if (name == null) continue;
            long coolDown = kitConfig.getLong("Cooldown", -1L);
            ItemStack offHandItem = kitConfig.getItemStack("Items.OffHand", null);
            LinkedList<ItemStack> armorContents = new LinkedList<ItemStack>();
            LinkedList<ItemStack> inventoryContents = new LinkedList<ItemStack>();
            ConfigurationSection armorSection = kitConfig.getConfigurationSection("Items.Armor");
            if (armorSection != null) {
                for (int key = 0; key < 4; ++key) {
                    ItemStack item = armorSection.getItemStack(String.valueOf(key), null);
                    armorContents.add(item);
                }
            }
            if ((inventorySection = kitConfig.getConfigurationSection("Items.Inventory")) != null) {
                for (int key = 0; key < 36; ++key) {
                    ItemStack item = inventorySection.getItemStack(String.valueOf(key), null);
                    inventoryContents.add(item);
                }
            }
            this._kits.put(name, new Kit(name, coolDown, offHandItem, armorContents.toArray(new ItemStack[0]), inventoryContents.toArray(new ItemStack[0])));
        }
    }

    public List<String> getAllKitNames() {
        return new ArrayList<String>(this._kits.keySet());
    }

    public Optional<Kit> getKit(String name) {
        return Optional.ofNullable(this._kits.get(name));
    }

    public boolean kitExists(String name) {
        return this._kits.containsKey(name);
    }

    public void addKit(Kit kit) {
        this._kits.put(kit.getName(), kit);
    }

    public void removeKit(String name) {
        this._kits.remove(name);
        File kitFile = this.getKitFile(name);
        if (kitFile.exists() && !kitFile.delete()) {
            ServerSystem.Instance.getLogger().warning("Failed to delete kit file: " + kitFile.getPath());
        }
    }

    public boolean saveKit(Kit kit) {
        ItemStack[] inventoryContents;
        File kitFile = this.getKitFile(kit.getName());
        YamlConfiguration kitConfig = new YamlConfiguration();
        kitConfig.set("Name", (Object)kit.getName());
        kitConfig.set("Cooldown", (Object)kit.getCoolDown());
        kitConfig.set("Items.OffHand", (Object)kit.getOffHandItem());
        ItemStack[] armorContents = kit.getArmorContents();
        if (armorContents != null) {
            for (int index = 0; index < armorContents.length; ++index) {
                kitConfig.set("Items.Armor." + index, (Object)armorContents[index]);
            }
        }
        if ((inventoryContents = kit.getInventoryContents()) != null) {
            for (int index = 0; index < inventoryContents.length; ++index) {
                kitConfig.set("Items.Inventory." + index, (Object)inventoryContents[index]);
            }
        }
        try {
            kitConfig.save(kitFile);
            return true;
        }
        catch (IOException exception) {
            ServerSystem.Instance.getLogger().log(Level.SEVERE, "Failed to save kit '" + kit.getName() + "'", exception);
            return false;
        }
    }

    public int saveAllKits() {
        int successCount = 0;
        for (Kit kit : this._kits.values()) {
            if (!this.saveKit(kit)) continue;
            ++successCount;
        }
        return successCount;
    }

    private File getKitFile(String name) {
        File kitDirectory = Path.of(ServerSystem.Instance.getDataFolder().getPath(), "Kits").toFile();
        if (!kitDirectory.exists()) {
            kitDirectory.mkdirs();
        }
        return new File(kitDirectory, name + ".yml");
    }
}

