/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.lightning;

import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.lightning.TabCompleterLightning;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@ServerSystemCommand(name="lightning", tabCompleter=TabCompleterLightning.class)
public class CommandLightning
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        Block block;
        if (!this.checkBasePermission(commandSender, "Lightning.Use")) {
            return;
        }
        if (this.handleConsoleWithNoTarget(commandSender, this.getSyntaxPath(command), label, arguments)) {
            return;
        }
        Optional<User> targetOptional = this.getTargetUser(commandSender, arguments);
        if (targetOptional.isEmpty()) {
            MessageBuilder.general("PlayerNotFound", commandSender).target(arguments[0]).build();
            return;
        }
        User targetUser = targetOptional.get();
        Player targetPlayer = targetUser.getPlayer();
        boolean isSelf = targetUser == commandSender;
        Block block2 = block = isSelf ? commandSender.getPlayer().getTargetBlockExact(100) : targetPlayer.getLocation().getBlock();
        if (block == null) {
            MessageBuilder.command("Lightning.NoTarget", commandSender).build();
            return;
        }
        boolean effectOnly = false;
        if (arguments.length > 1) {
            effectOnly = "visual".startsWith(arguments[1].toLowerCase());
        }
        if (effectOnly) {
            block.getWorld().strikeLightningEffect(block.getLocation());
        } else {
            block.getWorld().strikeLightning(block.getLocation());
        }
        if (isSelf) {
            MessageBuilder.general("Lightning.Success", commandSender).build();
        } else {
            MessageBuilder.general("Lightning.TargetSuccess", commandSender).target(targetPlayer.getName()).build();
        }
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Lightning";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Lightning.Use", false);
    }
}

