/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.moderation.mute;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Optional;
import java.util.Set;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.moderation.ModerationUtils;
import me.testaccount666.serversystem.commands.executables.moderation.mute.CommandMute;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.events.UserPrivateMessageEvent;
import me.testaccount666.serversystem.moderation.AbstractModeration;
import me.testaccount666.serversystem.moderation.AbstractModerationManager;
import me.testaccount666.serversystem.moderation.MuteModeration;
import me.testaccount666.serversystem.userdata.CachedUser;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.DurationParser;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@RequiredCommands(requiredCommands={CommandMute.class})
public class ListenerMute
implements Listener {
    public boolean canRegister(Set<ServerSystemCommandExecutor> requiredCommands) {
        return requiredCommands.stream().anyMatch(CommandMute.class::isInstance);
    }

    @EventHandler
    public void onPlayerChat(AsyncChatEvent event) {
        Optional<CachedUser> userOptional = ServerSystem.Instance.getUserManager().getUser(event.getPlayer());
        if (userOptional.isEmpty()) {
            return;
        }
        CachedUser cachedUser = userOptional.get();
        if (cachedUser.isOfflineUser()) {
            return;
        }
        User user = (User)cachedUser.getOfflineUser();
        AbstractModerationManager muteManager = user.getMuteManager();
        Optional<AbstractModeration> muteModerationOptional = muteManager.getActiveModeration();
        if (muteModerationOptional.isEmpty()) {
            return;
        }
        MuteModeration muteModeration = (MuteModeration)muteModerationOptional.get();
        this.handleMute((Cancellable)event, user, muteModeration);
        this.handleShadowMute(event, muteModeration);
    }

    @EventHandler
    public void onPrivateMessage(UserPrivateMessageEvent event) {
        User user = event.getSender();
        if (user instanceof ConsoleUser) {
            return;
        }
        AbstractModerationManager muteManager = user.getMuteManager();
        Optional<AbstractModeration> muteModerationOptional = muteManager.getActiveModeration();
        if (muteModerationOptional.isEmpty()) {
            return;
        }
        MuteModeration muteModeration = (MuteModeration)muteModerationOptional.get();
        this.handleMute(event, user, muteModeration);
        this.handleShadowMute(event, muteModeration);
    }

    private void handleMute(Cancellable event, User user, MuteModeration muteModeration) {
        if (muteModeration.isShadowMute()) {
            return;
        }
        event.setCancelled(true);
        String senderName = muteModeration.senderUuid().toString();
        Optional<String> senderNameOptional = ModerationUtils.findSenderName(muteModeration);
        if (senderNameOptional.isPresent()) {
            senderName = senderNameOptional.get();
        }
        MessageBuilder.command("Mute.Muted", user).sender(senderName).target(user.getName().get()).postModifier(message -> message.replace("<REASON>", muteModeration.reason()).replace("<DATE>", DurationParser.parseDate(muteModeration.expireTime(), user))).build();
    }

    private void handleShadowMute(AsyncChatEvent event, MuteModeration muteModeration) {
        if (!muteModeration.isShadowMute()) {
            return;
        }
        event.viewers().removeIf(audience -> {
            if (!(audience instanceof Player)) {
                return false;
            }
            Player player = (Player)audience;
            return player != event.getPlayer();
        });
    }

    private void handleShadowMute(UserPrivateMessageEvent event, MuteModeration muteModeration) {
        if (!muteModeration.isShadowMute()) {
            return;
        }
        event.getRecipients().removeIf(user -> {
            if (user instanceof ConsoleUser) {
                return false;
            }
            return user != event.getSender();
        });
    }
}

