/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.skull;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.skull.SkullCreator;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@ServerSystemCommand(name="skull")
public class CommandSkull
extends AbstractServerSystemCommand {
    private final SkullCreator _skullCreator = new SkullCreator();

    private static UUID ParseUuid(String input) {
        try {
            return UUID.fromString(input);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    private static URL ParseUrl(String input) {
        try {
            return URI.create(input).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            return null;
        }
    }

    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Skull.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        if (arguments.length == 0) {
            this.executeSelfSkull(commandSender);
            return;
        }
        if (!this.checkOtherPermission(commandSender, "Skull.Other", arguments[0])) {
            return;
        }
        this.executeOtherSkull(commandSender, arguments);
    }

    private void executeSelfSkull(User commandSender) {
        ItemStack skull = this._skullCreator.getSkull(commandSender.getName().get());
        commandSender.getPlayer().getInventory().addItem(new ItemStack[]{skull});
    }

    private void executeOtherSkull(User commandSender, String ... arguments) {
        String argument = arguments[0];
        ItemStack skull = this.createSkullFromInput(argument);
        commandSender.getPlayer().getInventory().addItem(new ItemStack[]{skull});
    }

    private ItemStack createSkullFromInput(String input) {
        UUID uuid = CommandSkull.ParseUuid(input);
        if (uuid != null) {
            return this._skullCreator.getSkull(uuid);
        }
        URL parsedUrl = CommandSkull.ParseUrl(input);
        if (parsedUrl != null) {
            return this._skullCreator.getSkullByTexture(parsedUrl);
        }
        return this._skullCreator.getSkull(input);
    }

    @Override
    public String getSyntaxPath(Command command) {
        return "Skull";
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Skull.Use", false);
    }
}

