/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.smelt;

import java.util.Iterator;
import java.util.Optional;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

@ServerSystemCommand(name="smelt")
public class CommandSmelt
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Smelt.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        ItemStack itemInHand = commandSender.getPlayer().getInventory().getItemInMainHand();
        if (itemInHand.getType().isAir()) {
            MessageBuilder.command("Smelt.NoItemInHand", commandSender).build();
            return;
        }
        Optional<ItemStack> smeltedItemOptional = this.getSmeltedItem(itemInHand);
        if (smeltedItemOptional.isEmpty()) {
            MessageBuilder.command("Smelt.NoSmeltedItem", commandSender).build();
            return;
        }
        ItemStack smeltedItem = smeltedItemOptional.get();
        smeltedItem.setAmount(itemInHand.getAmount());
        commandSender.getPlayer().getInventory().setItemInMainHand(smeltedItem);
        MessageBuilder.command("Smelt.Success", commandSender).postModifier(message -> message.replace("<INPUT>", itemInHand.getType().name()).replace("<OUTPUT>", smeltedItem.getType().name())).build();
    }

    private Optional<ItemStack> getSmeltedItem(ItemStack itemStack) {
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            FurnaceRecipe furnaceRecipe;
            Recipe recipe = (Recipe)recipeIterator.next();
            if (!(recipe instanceof FurnaceRecipe) || !(furnaceRecipe = (FurnaceRecipe)recipe).getInputChoice().test(itemStack)) continue;
            return Optional.of(furnaceRecipe.getResult());
        }
        return Optional.empty();
    }

    @Override
    public String getSyntaxPath(Command command) {
        throw new UnsupportedOperationException("Smelt command doesn't have an available syntax!");
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Smelt.Use", false);
    }
}

