/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.stack;

import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.executables.AbstractServerSystemCommand;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.ConsoleUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@ServerSystemCommand(name="stack")
public class CommandStack
extends AbstractServerSystemCommand {
    @Override
    public void execute(User commandSender, Command command, String label, String ... arguments) {
        if (!this.checkBasePermission(commandSender, "Stack.Use")) {
            return;
        }
        if (commandSender instanceof ConsoleUser) {
            MessageBuilder.general("NotPlayer", commandSender).build();
            return;
        }
        ItemStack itemInHand = commandSender.getPlayer().getInventory().getItemInMainHand();
        if (itemInHand.getType().isAir()) {
            MessageBuilder.command("Stack.NoItemInHand", commandSender).build();
            return;
        }
        itemInHand.setAmount(itemInHand.getMaxStackSize());
        MessageBuilder.command("Stack.Success", commandSender).build();
    }

    @Override
    public String getSyntaxPath(Command command) {
        throw new UnsupportedOperationException("Stack command doesn't have an available syntax!");
    }

    @Override
    public boolean hasCommandAccess(Player player, Command command) {
        return PermissionManager.hasCommandPermission((CommandSender)player, "Stack.Use", false);
    }
}

