/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.vanish;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.executables.vanish.CommandVanish;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.OfflineUser;
import me.testaccount666.serversystem.userdata.User;
import me.testaccount666.serversystem.utils.MessageBuilder;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockReceiveGameEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

@RequiredCommands(requiredCommands={CommandVanish.class})
public class ListenerVanish
implements Listener {
    private CommandVanish _commandVanish;

    public boolean canRegister(Set<ServerSystemCommandExecutor> requiredCommands) {
        AtomicBoolean canRegister = new AtomicBoolean(false);
        requiredCommands.forEach(command -> {
            if (!(command instanceof CommandVanish)) {
                return;
            }
            CommandVanish commandVanish = (CommandVanish)command;
            this._commandVanish = commandVanish;
            canRegister.set(true);
        });
        return canRegister.get();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        User user = this.getVanishedUser(event.getPlayer());
        if (user == null) {
            this.handleOtherPlayerJoin(event.getPlayer());
            return;
        }
        this.handleVanishedPlayerJoin(event, user);
    }

    @EventHandler
    public void onWorldChanged(PlayerChangedWorldEvent event) {
        User user = this.getVanishedUser(event.getPlayer());
        if (user == null) {
            return;
        }
        this._commandVanish.vanishPacket.sendVanishPacket(user);
    }

    @EventHandler
    public void onServerPing(PaperServerListPingEvent event) {
        HashSet listedPlayers = new HashSet(event.getListedPlayers());
        for (PaperServerListPingEvent.ListedPlayerInfo listedPlayer : listedPlayers) {
            User user = this.getVanishedUser(Bukkit.getPlayer((UUID)listedPlayer.id()));
            if (user == null) continue;
            event.getListedPlayers().remove(listedPlayer);
            event.setNumPlayers(event.getNumPlayers() - 1);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        User user = this.getVanishedUser(event.getPlayer());
        if (user == null) {
            return;
        }
        event.quitMessage(null);
    }

    @EventHandler
    public void onTargetPlayer(EntityTargetLivingEntityEvent event) {
        LivingEntity livingEntity = event.getTarget();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!this.isPlayerVanished(player)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        this.handleVanishRestriction(event.getPlayer(), (Cancellable)event, user -> user.getVanishData().canDrop(), "Vanish.Denied.Drop");
    }

    @EventHandler
    public void onChat(AsyncChatEvent event) {
        this.handleVanishRestriction(event.getPlayer(), (Cancellable)event, user -> user.getVanishData().canMessage(), "Vanish.Denied.Message");
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        this.handleVanishRestriction(event.getPlayer(), (Cancellable)event, user -> user.getVanishData().canInteract(), null);
    }

    @EventHandler
    public void onItemPickup(PlayerAttemptPickupItemEvent event) {
        this.handleVanishRestriction(event.getPlayer(), (Cancellable)event, user -> user.getVanishData().canPickup(), null);
    }

    @EventHandler
    public void onHangingEntityBreak(HangingBreakByEntityEvent event) {
        Player player;
        Entity entity = event.getRemover();
        if (entity instanceof Player && this.isPlayerVanished(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleCollide(VehicleEntityCollisionEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && this.isPlayerVanished(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onContainerOpen(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null || !(event.getClickedBlock().getState() instanceof InventoryHolder)) {
            return;
        }
        User user = this.getVanishedUser(event.getPlayer());
        if (user == null) {
            return;
        }
        this.temporarilySetSpectatorMode(event);
    }

    @EventHandler
    public void onGameEvent(BlockReceiveGameEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && this.isPlayerVanished(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onAdvancement(PlayerAdvancementDoneEvent event) {
        User user = this.getVanishedUser(event.getPlayer());
        if (user == null) {
            return;
        }
        event.message(null);
    }

    @EventHandler
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)ServerSystem.Instance, () -> {
            User user = this.getVanishedUser(event.getPlayer());
            if (user == null) {
                return;
            }
            this._commandVanish.vanishPacket.sendVanishPacket(user);
        }, 1L);
    }

    private void handleOtherPlayerJoin(Player joiningPlayer) {
        if (PermissionManager.hasCommandPermission((CommandSender)joiningPlayer, "Vanish.Show", false)) {
            return;
        }
        ServerSystem.Instance.getUserManager().getCachedUsers().stream().filter(cachedUser -> !cachedUser.isOfflineUser()).map(cachedUser -> (User)cachedUser.getOfflineUser()).filter(OfflineUser::isVanish).forEach(user -> this._commandVanish.vanishPacket.sendVanishPacket((User)user));
    }

    private void handleVanishedPlayerJoin(PlayerJoinEvent event, User user) {
        event.joinMessage(null);
        event.getPlayer().setSleepingIgnored(true);
        event.getPlayer().setMetadata("vanished", (MetadataValue)new FixedMetadataValue((Plugin)ServerSystem.Instance, (Object)true));
        this._commandVanish.vanishPacket.sendVanishPacket(user);
    }

    private void handleVanishRestriction(Player player, Cancellable cancellable, VanishDataCheck permissionCheck, String messagePath) {
        User user = this.getVanishedUser(player);
        if (user == null) {
            return;
        }
        if (permissionCheck.hasPermission(user)) {
            return;
        }
        cancellable.setCancelled(true);
        if (messagePath == null) {
            return;
        }
        MessageBuilder.command(messagePath, user).build();
    }

    private void temporarilySetSpectatorMode(PlayerInteractEvent event) {
        GameMode previousGameMode = event.getPlayer().getGameMode();
        event.getPlayer().setGameMode(GameMode.SPECTATOR);
        event.setCancelled(false);
        Bukkit.getScheduler().runTaskLater((Plugin)ServerSystem.Instance, () -> event.getPlayer().setGameMode(previousGameMode), 5L);
    }

    private User getVanishedUser(Player player) {
        if (player == null) {
            return null;
        }
        return ServerSystem.Instance.getUserManager().getUser(player).filter(cachedUser -> !cachedUser.isOfflineUser()).map(cachedUser -> (User)cachedUser.getOfflineUser()).filter(OfflineUser::isVanish).orElse(null);
    }

    private boolean isPlayerVanished(Player player) {
        return this.getVanishedUser(player) != null;
    }

    @FunctionalInterface
    private static interface VanishDataCheck {
        public boolean hasPermission(User var1);
    }
}

