/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.executables.weather;

import java.util.List;
import java.util.Optional;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemTabCompleter;
import me.testaccount666.serversystem.managers.PermissionManager;
import me.testaccount666.serversystem.userdata.User;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.WorldInfo;

public class TabCompleterWeather
implements ServerSystemTabCompleter {
    @Override
    public Optional<List<String>> tabComplete(User commandSender, Command command, String label, String ... arguments) {
        if (!PermissionManager.hasCommandPermission(commandSender, "Weather.Use", false)) {
            return Optional.of(List.of());
        }
        if (command.getName().equalsIgnoreCase("weather")) {
            if (arguments.length <= 1) {
                List<String> possibleCompletions = List.of("sun", "clear", "rain", "storm", "thunder");
                List<String> completions = possibleCompletions.stream().filter(completion -> completion.toLowerCase().startsWith(arguments[0].toLowerCase())).toList();
                return Optional.of(completions);
            }
            if (arguments.length == 2) {
                return this.handleWorldCompletions(1, arguments);
            }
            return Optional.of(List.of());
        }
        if (arguments.length == 1) {
            return this.handleWorldCompletions(0, arguments);
        }
        return Optional.of(List.of());
    }

    private Optional<List<String>> handleWorldCompletions(int index, String ... arguments) {
        if (!PermissionManager.hasPermission((CommandSender)Bukkit.getConsoleSender(), "Commands.Weather.World", false)) {
            return Optional.of(List.of());
        }
        List<String> possibleCompletions = Bukkit.getWorlds().stream().map(WorldInfo::getName).toList();
        List<String> completions = possibleCompletions.stream().filter(completion -> completion.toLowerCase().startsWith(arguments[index].toLowerCase())).toList();
        return Optional.of(completions);
    }
}

