/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.commands.management;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.commands.ServerSystemCommand;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemTabCompleter;
import me.testaccount666.serversystem.commands.wrappers.CommandExecutorWrapper;
import me.testaccount666.serversystem.commands.wrappers.TabCompleterWrapper;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.utils.ConstructorAccessor;
import me.testaccount666.serversystem.utils.FieldAccessor;
import me.testaccount666.serversystem.utils.MethodAccessor;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private final Function<SimpleCommandMap, Map<String, Command>> _commandMapAccessor = FieldAccessor.createGetter(SimpleCommandMap.class, "knownCommands");
    private final BiFunction<String, Plugin, PluginCommand> _pluginCommandConstructor = ConstructorAccessor.createConstructor(PluginCommand.class, String.class, Plugin.class);
    private final Consumer<? extends Server> _syncCommandsAccessor = MethodAccessor.createVoidAccessor(Bukkit.getServer().getClass(), "syncCommands");
    private final ConfigReader _configReader;
    private final Set<String> _registeredCommands = new HashSet<String>();
    private final Set<ServerSystemCommandExecutor> _registeredCommandInstances = new HashSet<ServerSystemCommandExecutor>();

    public CommandManager(ConfigReader configReader) {
        this._configReader = configReader;
    }

    public Optional<Command> getCommand(String commandName) {
        Map<String, Command> commandMap = this.getCommandMap();
        return Optional.ofNullable(commandMap.get(commandName));
    }

    public Optional<PluginCommand> getServerSystemCommand(String commandName) {
        return this.getCommandMap().values().stream().filter(PluginCommand.class::isInstance).map(PluginCommand.class::cast).filter(pluginCommand -> pluginCommand.getName().equalsIgnoreCase(commandName)).filter(pluginCommand -> pluginCommand.getPlugin() == ServerSystem.Instance).filter(pluginCommand -> pluginCommand.getExecutor() instanceof ServerSystemCommandExecutor).findFirst();
    }

    public Optional<ServerSystemCommandExecutor> getServerSystemCommandExecutor(String commandName) {
        return this.getServerSystemCommand(commandName).map(PluginCommand::getExecutor).filter(ServerSystemCommandExecutor.class::isInstance).map(ServerSystemCommandExecutor.class::cast);
    }

    private Map<String, Command> getCommandMap() {
        SimpleCommandMap commandMap = (SimpleCommandMap)Bukkit.getCommandMap();
        return this._commandMapAccessor.apply(commandMap);
    }

    private PluginCommand createCommand(String name) {
        return this._pluginCommandConstructor.apply(name, (Plugin)ServerSystem.Instance);
    }

    private void registerCommand(ServerSystemCommandExecutor command, ServerSystemTabCompleter completer, Map<String, List<String>> variantAliasMap) {
        Map<String, Command> commandMap = this.getCommandMap();
        variantAliasMap.forEach((variant, aliases) -> {
            aliases.forEach(commandMap::remove);
            PluginCommand bukkitCommand = this.createCommand((String)variant);
            bukkitCommand.setExecutor((CommandExecutor)new CommandExecutorWrapper(command));
            bukkitCommand.setTabCompleter((TabCompleter)new TabCompleterWrapper(completer));
            for (String alias : aliases) {
                commandMap.put(alias, (Command)bukkitCommand);
                commandMap.put("serversystem:" + alias, (Command)bukkitCommand);
                this._registeredCommands.add(alias);
                this._registeredCommands.add("serversystem:" + alias);
                this._registeredCommandInstances.add(command);
            }
            aliases = new ArrayList(aliases);
            aliases.remove(bukkitCommand.getName());
            bukkitCommand.setAliases(aliases);
        });
    }

    public void registerCommands() {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(new String[]{"me.testaccount666.serversystem.commands.executables"}).scan();){
            ClassInfoList serverSystemCommands = scanResult.getClassesWithAnnotation(ServerSystemCommand.class);
            serverSystemCommands.forEach(clazz -> this.processCommandExecutor(clazz.loadClass()));
        }
        this.syncCommands();
    }

    public void unregisterCommands() {
        Map<String, Command> commandMap = this.getCommandMap();
        this._registeredCommands.forEach(commandMap::remove);
        this._registeredCommands.clear();
        this._registeredCommandInstances.clear();
    }

    public Set<String> getRegisteredCommands() {
        return Collections.unmodifiableSet(this._registeredCommands);
    }

    public Set<ServerSystemCommandExecutor> getRegisteredCommandInstances() {
        return Collections.unmodifiableSet(this._registeredCommandInstances);
    }

    private void processCommandExecutor(Class<?> clazz) {
        Class<?> commandExecutor = clazz;
        if (!commandExecutor.isAnnotationPresent(ServerSystemCommand.class)) {
            return;
        }
        ServerSystemCommand commandAnnotation = commandExecutor.getAnnotation(ServerSystemCommand.class);
        assert (commandAnnotation != null);
        String command = commandAnnotation.name();
        if (!this.isCommandEnabled(command)) {
            return;
        }
        Map<String, List<String>> variantAliasMap = this.buildVariantAliasMap(command, commandAnnotation.variants());
        this.instantiateAndRegisterCommand(commandExecutor, commandAnnotation.tabCompleter(), variantAliasMap, command);
    }

    private boolean isCommandEnabled(String command) {
        return this._configReader.getBoolean("Commands." + command + ".Enabled", false);
    }

    private boolean isVariantEnabled(String command, String variant) {
        return this._configReader.getBoolean("Commands." + command + ".Variants." + variant + ".Enabled", false);
    }

    private Map<String, List<String>> buildVariantAliasMap(String command, String[] variants) {
        HashMap<String, List<String>> variantAliasMap = new HashMap<String, List<String>>();
        List<String> parentAliases = this.getAliases("Commands." + command + ".Aliases");
        variantAliasMap.put(command, parentAliases);
        for (String variant : variants) {
            if (!this.isVariantEnabled(command, variant)) continue;
            List<String> variantAliases = this.getAliases("Commands." + command + ".Variants." + variant + ".Aliases");
            variantAliasMap.put(variant, variantAliases);
        }
        return variantAliasMap;
    }

    private List<String> getAliases(String configPath) {
        return Arrays.stream(this._configReader.getString(configPath, "").split(",")).map(String::trim).filter(alias -> !alias.isEmpty()).toList();
    }

    private void instantiateAndRegisterCommand(Class<? extends ServerSystemCommandExecutor> commandExecutor, Class<? extends ServerSystemTabCompleter> tabCompleter, Map<String, List<String>> variantAliasMap, String command) {
        try {
            this.registerCommand(commandExecutor.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), tabCompleter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), variantAliasMap);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            throw new RuntimeException("Error registering command '" + command + "'!", exception);
        }
    }

    private void syncCommands() {
        this._syncCommandsAccessor.accept((Server)Bukkit.getServer());
        Bukkit.getOnlinePlayers().forEach(Player::updateCommands);
    }
}

