/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.listener.management;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.annotations.RequiredCommands;
import me.testaccount666.serversystem.commands.interfaces.ServerSystemCommandExecutor;
import me.testaccount666.serversystem.commands.management.CommandManager;
import me.testaccount666.serversystem.utils.MethodAccessor;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ListenerManager {
    private final CommandManager _commandManager;
    private final Set<Listener> _registeredListeners = new HashSet<Listener>();

    public ListenerManager(CommandManager commandManager) {
        this._commandManager = commandManager;
    }

    public void registerListeners() {
        try (ScanResult scan = new ClassGraph().enableAllInfo().scan();){
            ClassInfoList listeners = scan.getClassesImplementing(Listener.class);
            listeners.forEach(listenerClass -> {
                try {
                    boolean shouldRegister;
                    Class loadedClass = listenerClass.loadClass();
                    Listener listener = (Listener)loadedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (loadedClass.isAnnotationPresent(RequiredCommands.class) && !(shouldRegister = this.shouldRegister(listener))) {
                        return;
                    }
                    Bukkit.getPluginManager().registerEvents(listener, (Plugin)ServerSystem.Instance);
                    this._registeredListeners.add(listener);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                    throw new RuntimeException("Failed to register listener '" + listenerClass.getName() + "'", exception);
                }
            });
        }
    }

    public void unregisterListeners() {
        this._registeredListeners.forEach(HandlerList::unregisterAll);
        this._registeredListeners.clear();
    }

    private Optional<ServerSystemCommandExecutor> findInstance(Class<? extends ServerSystemCommandExecutor> commandExecutor) {
        for (ServerSystemCommandExecutor instance : this._commandManager.getRegisteredCommandInstances()) {
            if (!instance.getClass().isAssignableFrom(commandExecutor)) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    private boolean shouldRegister(Listener listener) {
        RequiredCommands requiredCommands = listener.getClass().getAnnotation(RequiredCommands.class);
        HashSet<ServerSystemCommandExecutor> instances = new HashSet<ServerSystemCommandExecutor>();
        for (Class<? extends ServerSystemCommandExecutor> command : requiredCommands.requiredCommands()) {
            Optional<ServerSystemCommandExecutor> instance = this.findInstance(command);
            if (instance.isEmpty()) continue;
            instances.add(instance.get());
        }
        try {
            BiFunction<Listener, Set, Boolean> methodAccessor = MethodAccessor.createAccessor(listener.getClass(), "canRegister", Set.class, Boolean.class);
            return methodAccessor.apply(listener, instances);
        }
        catch (NoSuchMethodError | RuntimeException exception) {
            ServerSystem.getLog().log(Level.SEVERE, "Listener '" + listener.getClass().getName() + "' requires a 'canRegister' method!", exception);
            return false;
        }
    }
}

