/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.managers.database.moderation;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.managers.config.ConfigReader;
import me.testaccount666.serversystem.managers.database.HikariConfigUtil;
import me.testaccount666.serversystem.managers.database.moderation.AbstractModerationDatabaseManager;

public class MySqlModerationDatabaseManager
extends AbstractModerationDatabaseManager {
    public MySqlModerationDatabaseManager(ConfigReader configReader) {
        super(configReader);
    }

    @Override
    protected void initializeConnection() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            return;
        }
        HikariConfig config = HikariConfigUtil.configureMySql(this.configReader, "Moderation.MySQL", "moderation-hikari-pool");
        this.dataSource = new HikariDataSource(config);
        ServerSystem.getLog().info("Successfully initialized MySQL connection pool for moderation.");
    }

    @Override
    protected void createTablesIfNotExist() throws SQLException {
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("    CREATE TABLE IF NOT EXISTS Moderation (\n        ID INT AUTO_INCREMENT PRIMARY KEY,\n        TargetUUID VARCHAR(36) NOT NULL,\n        SenderUUID VARCHAR(36) NOT NULL,\n        IssueTime BIGINT NOT NULL,\n        ExpireTime BIGINT NOT NULL,\n        Reason TEXT NOT NULL,\n        Type VARCHAR(20) NOT NULL,\n        INDEX idx_target (TargetUUID),\n        INDEX idx_type (Type)\n    )\n");
        }
    }
}

