/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.placeholderapi;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.placeholderapi.Placeholder;

public class PlaceholderManager {
    private final Map<String, Placeholder> _registeredPlaceholders = new HashMap<String, Placeholder>();

    public void registerPlaceholders() {
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackages(new String[]{"me.testaccount666.serversystem.placeholderapi.executables"}).scan();){
            ClassInfoList placeholderClasses = scanResult.getClassesImplementing(Placeholder.class);
            for (ClassInfo placeholderClass : placeholderClasses) {
                try {
                    Placeholder placeholder = (Placeholder)placeholderClass.loadClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    placeholder.getIdentifiers().forEach(identifier -> this._registeredPlaceholders.put(identifier.toLowerCase(), placeholder));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                    ServerSystem.getLog().log(Level.SEVERE, "Error registering placeholder '" + placeholderClass.getName() + "'", exception);
                }
            }
        }
    }

    public Optional<Placeholder> getPlaceholder(String identifier) {
        identifier = identifier.toLowerCase();
        return Optional.ofNullable(this._registeredPlaceholders.get(identifier));
    }
}

