/*
 * Decompiled with CFR 0.152.
 */
package me.testaccount666.serversystem.updates;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import me.testaccount666.serversystem.ServerSystem;
import me.testaccount666.serversystem.utils.Version;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class AbstractUpdateChecker {
    protected final URI updateURI;
    protected boolean isUpdateAvailable;
    protected boolean isUpdateDownloaded;
    protected boolean autoUpdate;
    protected Version latestVersion = null;
    protected boolean notifiedOnce;

    public CompletableFuture<Boolean> hasUpdate() {
        ServerSystem.getLog().fine("Checking for updates...");
        if (this.isUpdateAvailable) {
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)ServerSystem.Instance, () -> {
            try (HttpClient client = HttpClient.newHttpClient();){
                HttpRequest request = HttpRequest.newBuilder().timeout(Duration.ofMinutes(1L)).uri(this.updateURI).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                String body = response.body();
                Version parsedLatestVersion = this.parseLatestVersion(body);
                if (parsedLatestVersion.compareTo(ServerSystem.CURRENT_VERSION) > 0) {
                    this.isUpdateAvailable = true;
                    this.latestVersion = parsedLatestVersion;
                    ServerSystem.getLog().info("A new update is available! Current version: " + String.valueOf(ServerSystem.CURRENT_VERSION) + ", Latest version: " + String.valueOf(parsedLatestVersion));
                } else if (!this.notifiedOnce) {
                    this.notifiedOnce = true;
                    ServerSystem.getLog().info("You're running the latest version of ServerSystem <3");
                }
                future.complete(this.isUpdateAvailable);
            }
            catch (Exception exception) {
                ServerSystem.getLog().log(Level.WARNING, "Failed to check for updates!", exception);
                future.completeExceptionally(exception);
            }
        });
        return future;
    }

    public CompletableFuture<Boolean> downloadUpdate() {
        if (!this.autoUpdate) {
            ServerSystem.getLog().info("Auto update is disabled. Update can be downloaded manually.");
            return CompletableFuture.completedFuture(false);
        }
        if (this.isUpdateDownloaded) {
            return CompletableFuture.completedFuture(true);
        }
        ServerSystem.getLog().info("Downloading update...");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)ServerSystem.Instance, () -> {
            if (this.latestVersion == null) {
                future.completeExceptionally(new IllegalStateException("No version info available for download."));
                return;
            }
            String downloadUrl = this.getDownloadUrl();
            try (HttpClient client = HttpClient.newHttpClient();){
                int bytesRead;
                HttpRequest request = HttpRequest.newBuilder().timeout(Duration.ofMinutes(1L)).uri(URI.create(downloadUrl)).GET().build();
                ServerSystem.getLog().info("Downloading update from " + downloadUrl);
                HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                if (response.statusCode() != 200) {
                    future.completeExceptionally(new RuntimeException("Failed to download update: HTTP " + response.statusCode()));
                    return;
                }
                Path pluginDir = ServerSystem.Instance.getDataFolder().getParentFile().toPath();
                Path updateFile = pluginDir.resolve("update").resolve(this.getJarFileName());
                Files.createDirectories(updateFile.getParent(), new FileAttribute[0]);
                InputStream in = response.body();
                OutputStream out = Files.newOutputStream(updateFile, new OpenOption[0]);
                byte[] buffer = new byte[8192];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                out.close();
                ServerSystem.getLog().info("Update downloaded to " + String.valueOf(updateFile));
                this.isUpdateDownloaded = true;
                future.complete(true);
            }
            catch (Exception exception) {
                future.completeExceptionally(exception);
            }
        });
        return future;
    }

    protected abstract Version parseLatestVersion(String var1);

    protected abstract String getDownloadUrl();

    protected String getJarFileName() {
        Path jarPath = Paths.get(ServerSystem.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        Object name = jarPath.getFileName().toString();
        if (!((String)name).toLowerCase().endsWith(".jar")) {
            name = (String)name + ".jar";
        }
        return name;
    }

    public AbstractUpdateChecker(URI updateURI) {
        this.updateURI = updateURI;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }
}

